<?php
$fetch_status = get_option('quivers_fetch_status');

add_filter( 'manage_edit-shop_order_columns', 'quivers_order_status_label_column', 20 );
function quivers_order_status_label_column($columns)
{
    $reordered_columns = array();

    // Inserting columns to a specific location
    foreach( $columns as $key => $column){
        $reordered_columns[$key] = $column;
        if( $key ==  'order_status' ){
            // Inserting after "Status" column
            $reordered_columns['quiver_order_status'] = __( 'Quivers Status','theme_domain');
        }
    }
    return $reordered_columns;
}

add_action( 'manage_shop_order_posts_custom_column' , 'quivers_order_status_label_content', 20, 2 );
function quivers_order_status_label_content( $column, $post_id )
{
    switch ( $column )
    {
        case 'quiver_order_status' :
            // Get custom post meta data
            $quivers_order_id = get_post_meta( $post_id, 'quivers_order_id', true );
            $order = wc_get_order($post_id);
               $order_status = $order->get_status();
            // if($order_status!='cancelled'){
                if(!$quivers_order_id ){
                    //order status match
                    $status_match = false;
                    $fetch_status = get_option('quivers_fetch_status');
                    if($fetch_status==null||$fetch_status==""){
                        $fetch_status = ["in-progress", "on-hold", "processing"];
                    }
                    foreach ($fetch_status as $property => $status) {
                         if($status==$order_status){
                            $status_match = true;
                         } 
                    }
                    if($status_match){
                        $created_date =new DateTime($order->get_date_created());
                        $today = current_datetime();
                        $days_diff = $today->diff($created_date)->format("%a"); 
                        if($days_diff<1){
                              echo '<mark id="quivers-yellow" class="order-status quivers-yellow  quivers-tooltip"><span>Pending Sync</span></mark>';
                        } 
                        if($days_diff>=1){
                             echo '<mark id="quivers-red" class="order-status quivers-red  quivers-tooltip"><span>Sync Problem</span></mark>'; 
                        }  
                    }else{
                        echo '<mark id="quivers-gray" class="order-status quivers-gray  quivers-tooltip"><span>Incompatible status for syncing</span></mark>'; 
                    }
                }else{
                    echo '<mark id="quivers-green" class="order-status quivers-green  quivers-tooltip"><span>Synced to Quivers</span><span class="quivers-tooltiptext">Tooltip text</span></mark>'; 
                }
                //}
       
            break;

    }
}



?>