<?php

class My_Order_Status { //Class Begins

    function __construct(){
        add_action( 'woocommerce_order_status_changed', array($this,'action_woocommerce_order_status_changed'), 20, 4);
        add_action( 'woocommerce_order_actions_end', array($this,'add_alert_on_action'));
        add_action( 'admin_enqueue_scripts', array($this,'my_custom_scripts'));
        add_action( 'wp_ajax_order_tax_refund', array($this, 'order_tax_refund'));
    }

    function add_alert_on_action(){
        /*
        As we are calling my_custom_scripts with callback argument '1', 
        this function is added because call_user_func_array() expects parameter 1 to be a valid callback,
        */
    }
   
    function order_tax_refund() {
        global $wpdb;
        $order = new WC_Order($_POST['my_order_id']);
        $order->set_date_modified(current_time('mysql'));
        $order_id = $order->get_id();
        $table_name = $wpdb->prefix . 'woocommerce_order_items';
		$order_item_data = $wpdb->get_results("SELECT order_item_id, order_item_name FROM $table_name WHERE order_id = $order_id and order_item_type = 'fee'");
        $order_item_ids= [];
        $order_item_idss= [];
        foreach($order_item_data as $kdata => $data){
            
            $order_item_idss= [];
            foreach($data as $k => $value){
            $value = (array)$value;
            array_push($order_item_idss,$value);
        }
            array_push($order_item_ids,$order_item_idss);
    }
        $item_tax_mapping = [];
        $item_tax_mappings = [];
        $tax_item_id= [];
        //$tax_id= [];
        foreach ($order->get_items() as $item_id => $item) {
            $tax_item_id= [];
            $tax_custom = json_decode($item->get_meta('_item_custom_fee_value'),true);
            $tax = json_decode($item->get_meta('_item_tax_value'),true);
            foreach($tax_custom as $kdata => $data){
                $tax_id= [];
                foreach($data as $k => $value){
                $value = [array($kdata),$value];
                array_push($tax_id,(array)$value);
               
            }
        array_push($tax_item_id,$tax_id);
        }
        foreach($tax as $kdata => $data){
            foreach($data as $k => $value){
            $tax_id= [];
            $estimated_tax = 'Estimated Tax';
            $value = [array($estimated_tax),$value];
            array_push($tax_id,(array)$value); 
        }
        array_push($tax_item_id,$tax_id);
       
    }
   
    foreach($order_item_ids as $key => $val){
        foreach($tax_item_id as $tid => $vals){
            if($val[1] == $vals[0][0]){
                $fee_id = $val[0];
                $tax_item_id[$tid]["tax field"] = $fee_id[0];
            }
            
    }
}
$item_tax_mapping[$item_id] = $tax_item_id;
    

       
        } 
        wp_send_json($item_tax_mapping);
    }

    function my_custom_scripts() {
        wp_enqueue_script('my_order_js', plugin_dir_url(__FILE__) . '/my_order_status.js');
    }

    function action_woocommerce_order_status_changed($order_id, $status_transition_from, $status_transition_to, $instance){
        // only if previous status was 'on-hold'
        $startTime = microtime(true);
        $log = new My_WC_LogTracking();
        if ($this->is_request_to_rest_api() != 1 && $status_transition_from == 'on-hold'){
            $curl_client = curl_init();
            $quivers_sandbox = get_option('wc_settings_tab_demo_sandbox_status');
            $quivers_apikey = get_option('wc_settings_tab_demo_apikey');
            $options = $this->validateOrderAction($order_id, $quivers_sandbox, $quivers_apikey, $curl_client);
            $is_transition_valid = $options[0];
            $exist_on_quivers = $options[1];
            if (!$is_transition_valid){
                // revert back the status transition
                $order = new WC_Order($order_id);
                $order->update_status('on-hold');
                throw new Exception('Order status cannot be changed from '.$status_transition_from.' to '.$status_transition_to.' , because this order is already shipped by a Retailer.');
                echo "reacehd here";
            }
            if (!$exist_on_quivers){
            }
        }
        else{
        }
        
        if($this->is_request_to_rest_api()) {
            $log->order_status(["Status"=>$status_transition_from.'-'.$status_transition_to,'order_id'=>$order_id], date('r', $startTime)."UTC");
        }  
    }

    function is_request_to_rest_api() {
        if ( empty( $_SERVER['REQUEST_URI'] ) ) {
          return false;
        }
        $rest_prefix = trailingslashit( rest_get_url_prefix() );
        $woocommerce = ( false !== strpos( $_SERVER['REQUEST_URI'], $rest_prefix . 'wc/' ) );
        // Allow third party plugins use our authentication methods.
        $third_party = ( false !== strpos( $_SERVER['REQUEST_URI'], $rest_prefix . 'wc-' ) );
        return apply_filters( 'woocommerce_rest_is_request_to_rest_api', $woocommerce || $third_party );
      }

    function validateOrderAction($orderId, $quiversSandbox, $quiversAPIKey, $ch) {
        $startTime = microtime(true);
        $log = new My_WC_LogTracking();
        $orderUpdateValidateUrl = 'https://middleware.quiversdemo.com/profile/order/status';
        if($quiversSandbox == 'no') {
           $orderUpdateValidateUrl = "https://middleware.quivers.com/profile/order/status";
        }
        $payload = array(
           'client_type'=> 'Woocommerce',
           'profile_id'=> get_option('wc_middleware_profile_id'),
           'order_id'=> $orderId,
        );
        $log->session_start(["Order Data"=>$payload], date('r', $startTime)."UTC");
        curl_setopt($ch, CURLOPT_URL, $orderUpdateValidateUrl);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));  //Post Fields
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $request = ["orderUpdateValidateUrl" => "https://middleware.quiversdemo.com/profile/order/status", "order_data" => json_encode($payload)];
        if($quiversSandbox == 'no') {
           $request = ["orderUpdateValidateUrl" => "https://middleware.quivers.com/profile/order/status", "order_data" => json_encode($payload)];
        }
        $headers = [
            'Content-Type: application/json',
            'Authorization: apikey '.$quiversAPIKey,
	        'Expect :'
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $server_output = curl_exec ($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);
        $log->validate_order_action("HTTP Code*", $httpcode, date('r', $startTime)."UTC", date('r', $endTime)."UTC");
        if($httpcode!=200) {
           return array(false, true);
        }
        $responseDecoded = json_decode($server_output, true);
        $endTime = microtime(true);
        $log->validate_order_action($request, $responseDecoded, date('r', $startTime)."UTC", date('r', $endTime)."UTC");
        if(empty($responseDecoded))
            return array(true, false);
        foreach ($responseDecoded as $key => $item) {
            if( $item['Value'] == 60 && $item['performed_by'] == 'Retailer' ) {
                return array(false, true);
            }
        }
       return array(true, true);
   }
}
// =========================================================================
// REGISTER CUSTOM STATUSES FOR KLEINN (QT-4314)
// =========================================================================
add_action( 'init', 'register_custom_statuses_as_order_status' );
function register_custom_statuses_as_order_status() {
    register_post_status( 'wc-in-progress', array(
        'label'                     => __('In progress'),
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop( 'In progress <span class="count">(%s)</span>', 'In progress <span class="count">(%s)</span>' )
    ) );

    register_post_status( 'wc-order-shipped', array(
        'label'                     => __('Order shipped'),
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop( 'Order shipped <span class="count">(%s)</span>', 'Order shipped <span class="count">(%s)</span>' )
    ) );

    register_post_status( 'wc-order-cancelled', array(
        'label'                     => __('Order cancelled'),
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop( 'Order cancelled <span class="count">(%s)</span>', 'Order cancelled <span class="count">(%s)</span>' )
    ) );

    register_post_status( 'wc-order-refunded', array(
        'label'                     => __('Order refunded'),
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop( 'Order refunded <span class="count">(%s)</span>', 'Order refunded <span class="count">(%s)</span>' )
    ) );
}

// Add to list of WC Order statuses
add_filter( 'wc_order_statuses', 'add_additional_custom_statuses_to_order_statuses' );
function add_additional_custom_statuses_to_order_statuses( $order_statuses ) {
    $new_order_statuses = array();
    // add new order status after processing
    foreach ( $order_statuses as $key => $status ) {
        $new_order_statuses[ $key ] = $status;
        if ( 'wc-processing' === $key ) {
            $new_order_statuses['wc-in-progress'] = __('In progress');
            $new_order_statuses['wc-order-shipped'] = __('Order shipped');
            $new_order_statuses['wc-order-cancelled'] = __('Order cancelled');
            $new_order_statuses['wc-order-refunded'] = __('Order refunded');

        }
    }
    return $new_order_statuses;
}

if( class_exists("My_Order_Status") ) $GLOBALS['my_order_status'] = new My_Order_Status();

?>
