<?php
//Simple Products
//Add a text box in General section
add_action( 'woocommerce_product_options_pricing', 'create_product_upc_code_field' );

function create_product_upc_code_field() {
	$upcKey = get_option('wc_settings_tab_demo_quivers_upc_field');
	$args = array(
		'id'            => 'quivers_upc',
		'label'         => __( 'UPC', 'cfwc' ),
		'class'					=> 'cfwc-custom-field',
		'desc_tip'      => false,
		'description'   => __( '', 'ctwc' ),
	);
	woocommerce_wp_text_input( $args );
	?> 
	<input type="hidden" id="quivers_hidden_upc" value="<?php echo $upcKey; ?>"/> 
	<?php
}

// Save the value in meta data for simple products
add_action( 'woocommerce_process_product_meta', 'save_product_upc_code' );

function save_product_upc_code( $post_id ) {
	$upcKey = get_option('wc_settings_tab_demo_quivers_upc_field');
	$title = $_POST['quivers_upc'];
	$product = wc_get_product( $post_id );
    $product->update_meta_data( 'quivers_upc', sanitize_text_field( $title ) );
    $product->update_meta_data( 'quivers_hidden_upc', $upcKey );
    $product->save();
}

//Variant Proucts
//Add a text box in variants section
add_action( 'woocommerce_variation_options', 'create_variation_upcs_field', 11, 3 );

function create_variation_upcs_field($loop, $variation_data, $variation ) {
	$upcKey = get_option('wc_settings_tab_demo_quivers_upc_field');
    $args = array(
		'id' => 'quivers_upc'.'[' . $loop . ']',
		'class' => 'short',
		'label' => __( 'UPC', 'woocommerce' ),
		'value' => get_post_meta( $variation->ID, 'quivers_upc', true ),
		'desc_tip'      => false,
		'description'   => __( '', 'ctwc' ),
		"wrapper_class" => 'form-row'
	);
    woocommerce_wp_text_input( $args );
    ?> 
    <input type="hidden" class="quivers_hidden_upc" name="quivers_hidden_upc[<?php echo esc_attr( $loop ); ?>]" value="<?php echo $upcKey ?>"/>
	<?php
}

// Save the value in meta data for variants
add_action( 'woocommerce_save_product_variation', 'save_variation_upc_field', 10, 2 );

function save_variation_upc_field( $variation_id, $i ) {
	$upcKey = get_option('wc_settings_tab_demo_quivers_upc_field');
	$quivers_custom_upc  = $_POST['quivers_upc'][$i];
    if ( isset( $quivers_custom_upc ) ) update_post_meta( $variation_id, 'quivers_upc', esc_attr( $quivers_custom_upc ) );
    update_post_meta( $variation_id, 'quivers_hidden_upc', $upcKey );
}
