<?php

//Simple Products
//Add a check box in General section
add_action( 'woocommerce_product_options_pricing', 'create_pre_order_checkbox' );

function create_pre_order_checkbox() {
    $preOrderKey = get_option('wc_settings_tab_demo_quivers_preorder_key');
    $args = array(
        'id'            => "quivers_custom_is_preorder",
        'label'         => __( 'Pre-Order Availability ', 'cfwc' ),
        'class'                 => 'cfwc-custom-field',
        'desc_tip'      => false,
        'description'   => __( '', 'ctwc' ),
    );
    woocommerce_wp_checkbox( $args );
    ?> 
    <input type="hidden" id="quivers_hidden_preorder" value="<?php echo $preOrderKey; ?>"/> 
    <?php
}

add_action( 'woocommerce_process_product_meta', 'save_is_pre_order' );

// Save the value in meta data for simple products
function save_is_pre_order( $post_id ) {
    $preOrderKey = get_option('wc_settings_tab_demo_quivers_preorder_key');
    $preOrderValue = $_POST['quivers_custom_is_preorder'];
    $product = wc_get_product( $post_id );
    $product->update_meta_data('quivers_custom_is_preorder', $preOrderValue);
    $product->update_meta_data( 'quivers_hidden_preorder', $preOrderKey );
    $product->save();
}

//Varant Proucts
//Add a check box in variants section
add_action( 'woocommerce_variation_options', 'variation_settings_fields', 10, 3 );

function variation_settings_fields($loop, $variation_data, $variation ) {
    $preOrderKey = get_option('wc_settings_tab_demo_quivers_preorder_key');
    $is_preorder = get_post_meta( $variation->ID, 'quivers_custom_is_preorder', true);
    if ( $is_preorder == 'yes' ) {
        $is_preorder = 'checked';
    }
    else {
        $is_preorder = '';     
    }
    ?>
    <label class="tips" data-tip="<?php esc_attr_e( 'Enable this option to make the product available as pre order', 'woocommerce' ); ?>">
        <?php esc_html_e( 'Pre-Order Availability', 'woocommerce' ); ?>
        <input type="checkbox" class="checkbox variable_is_preorder" name="quivers_custom_is_preorder[<?php echo esc_attr( $loop ); ?>]"<?php echo $is_preorder;?>/>
    </label>
    <input type="hidden" class="quivers_hidden_preorder" name="quivers_hidden_preorder[<?php echo esc_attr( $loop ); ?>]" value="<?php echo $preOrderKey ?>"/>
    <?php
}

// Save the value in meta data for variants
add_action( 'woocommerce_save_product_variation', 'save_variation_settings_fields', 10, 2 );

function save_variation_settings_fields( $variation_id, $i ) {
    $preOrderKey = get_option('wc_settings_tab_demo_quivers_preorder_key');
    $preOrderValue = 'no';
    if (isset($_POST['quivers_custom_is_preorder'][$i] )) {
        $preOrderValue= 'yes';
    }
    update_post_meta( $variation_id, 'quivers_custom_is_preorder', $preOrderValue); 
    update_post_meta( $variation_id, 'quivers_hidden_preorder', $preOrderKey );    
}
