function CancelAndInvoice(){
	
	var instance = {
		block_obj : {message: null,overlayCSS: {background: '#fff',opacity: 0.6}},
		order_id : parseInt(jQuery("input[name='order_id']").val()),
		all_refunded : true,
		all_done: true,
		my_ajax : null,
	};

	instance.init = function(){

		instance.disableButtons();
		// instance.shipButtonStatus();
		instance.hideShippingHtml();
		jQuery("#order_line_items .item .item_status").attr('width','20%');
		jQuery("#order_line_items .item .wc-order-edit-line-item").html('');
		jQuery("#invoice_overlay #inner .overlay-body table th .invoice_all_items").on('click', function(){
			var setValue = jQuery("#invoice_overlay #inner .overlay-body table th .invoice_all_items").prop('checked');
			jQuery("#invoice_overlay #inner .overlay-body table td input.invoice_item").each(function(){
				jQuery(this).prop('checked', setValue);
			});
		});
		jQuery("#invoice_overlay #inner .overlay-body table th .ship_all_items").on('click', function(){
			var setValue = jQuery("#invoice_overlay #inner .overlay-body table th .ship_all_items").prop('checked');
			jQuery("#invoice_overlay #inner .overlay-body table td input.invoice_item2").each(function(){
				jQuery(this).prop('checked', setValue);
			});
		});

		jQuery("#order_line_items .item_status").each(function(){
			jQuery("div:last-child", this).css("font-weight","bold");
		});

		// instance.refundCheck();
		instance.completedCheck();

		jQuery(".edit-cancel").on('click', function(e){
			e.preventDefault();
			if(!jQuery(".edit-cancel").hasClass("disabled")){
				var res = confirm("Are u sure you want to cancel this order. This action can't be undone.");
				jQuery( '#woocommerce-order-items' ).block(instance.block_obj);
				if(res === true){
					var data = {
						action 		: "woocommerce_cancel_order_manually",
						my_order_id	: instance.order_id
					};
					jQuery.post(ajaxurl, data, function(res){
						if(res){
							jQuery( '#woocommerce-order-items' ).unblock();
							location.reload();
						}else{
							alert("Request couldn't be completed!");
						}
					});
				}
			}
		}); 

		jQuery("#invoice_overlay #inner .overlay-footer .create_invoice").on('click', function(e){
			e.preventDefault();
			var item_details = [];
			var ship_details = [];
			if(jQuery(this).hasClass("ship_as_well")){
				if(jQuery("#invoice_overlay select[name='select_carrier_invoice']").val() == ''){
					alert("Please enter the carrier.");
					return false;
				}
				jQuery(".to_be_invoiced2").each(function(){
					var name = jQuery("td.item_name2", this).html();
					var item_id = jQuery(".item_status2 input", this).attr("product-id");
					var variation = jQuery(".item_status2 input", this).attr('variation-id');
					var item_qty = jQuery(".item_qty2", this).html();
					var invoiced_qty = jQuery("input[name='item_"+item_id+"_"+variation+"_2']").prop('checked') ? jQuery(".invoice_qty2 input", this).val() : '0';
					var item_total = jQuery("input[name='item_total_"+item_id+"_"+variation+"_2']").val();
					var in_order_item_id = jQuery(".item_status input", this).attr("item-id");
					// if(invoiced_qty > 0 && jQuery("input[name='item_"+item_id+"_"+variation+"_2']").prop('checked')){
					ship_details.push({item_name: name ,in_order_item_id:in_order_item_id ,item_id: item_id ,variation_id: variation ,item_qty: item_qty , invoiced_qty: invoiced_qty, item_total: item_total});
					// }
				});
			}
			jQuery( '#invoice_overlay' ).block(instance.block_obj);
			jQuery(".to_be_invoiced").each(function(){
				var name = jQuery("td.item_name", this).html();
				var item_id = jQuery(".item_status input", this).attr("product-id");
				var variation = jQuery(".item_status input", this).attr('variation-id');
				var item_qty = jQuery(".item_qty", this).html();
				var invoiced_qty = jQuery("input[name='item_"+item_id+"_"+variation+"']").prop('checked') ? jQuery(".invoice_qty input", this).val() : '0';
				var item_total = jQuery("input[name='item_total_"+item_id+"_"+variation+"']").val();
				var in_order_item_id = jQuery(".item_status input", this).attr("item-id");
				// if(invoiced_qty > 0 && jQuery("input[name='item_"+item_id+"_"+variation+"']").prop('checked')){
				item_details.push({item_name: name ,in_order_item_id:in_order_item_id ,item_id: item_id ,variation_id: variation ,item_qty: item_qty , invoiced_qty: invoiced_qty, item_total: item_total});
				// }
			});
			var it_det = [];
			item_details.filter(function(item){
				if(ship_details.length > 0){
					ship_details.filter(function(ship){
						if(item.item_id == ship.item_id && item.variation_id == ship.variation_id){
							item.invoiced_qty = (parseInt(item.invoiced_qty) + parseInt(ship.invoiced_qty)).toString();
						}
					});
				}
				if(item.invoiced_qty > 0){
					it_det.push(item);
				}
			});
			// console.log(it_det)
			var carrier = jQuery("#invoice_overlay #inner .overlay-body .carrier select").val();
			var tracking_num = jQuery("#invoice_overlay #inner .overlay-body .tracking input").val();
			
			var data = {
				action 		: "woocommerce_add_entry_to_table",
				my_order_id	: instance.order_id,
				item_details: it_det,
				carrier		: carrier,
				tracking	: tracking_num,
				shipped		: jQuery(this).hasClass("ship_as_well")
			};
			// console.log(data);
			if(it_det.length > 0){
				// console.log('data',data);
				jQuery.post(ajaxurl, data, function(res){
					if(res){
						location.reload();
					}else{
						alert("Request couldn't be completed!");
					}
					jQuery( '#invoice_overlay' ).unblock();
				});
			} else{
				alert("Please add items.");
				jQuery( '#invoice_overlay' ).unblock();
				jQuery(".invoice_qty").focus();
			}
		});

		/*open invoice overlay*/
		jQuery(".edit-invoice#cus_invoice").on('click', function(e){
			e.preventDefault();
			if(!jQuery(".edit-invoice").hasClass("disabled")){
				jQuery( '#woocommerce-order-items' ).block(instance.block_obj);
				jQuery( '#woocommerce-custom-invoice-data' ).block(instance.block_obj);
				var data = {
					action 		: "woocommerce_generate_invoice",
					my_order_id	: instance.order_id
				};
				instance.my_ajax = jQuery.post(ajaxurl, data, function(res){
					if(res !== ''){
						instance.create_rows(res);
						instance.selectToInvoice();
						instance.hideTables(res);						
						// jQuery("#invoice_overlay .overlay-body #inv_ship").addClass('hidden');
						jQuery("#invoice_overlay").removeClass("hidden");
					}else{
						alert("Request couldn't be completed!");
					}
					jQuery( '#woocommerce-order-items' ).unblock();
					jQuery( '#woocommerce-custom-invoice-data' ).unblock();
				});
			}
		});
		/*close invoice overlay*/
		jQuery("#invoice_overlay #inner .overlay-header span").on('click', function(){
			jQuery("#invoice_overlay").addClass("hidden");
		});

		jQuery(".refund_order_item_qty").on('keyup', function(){
			instance.validateRefundQty(this);
		});

		jQuery(".refund_order_item_qty").on('click', function(){
			instance.validateRefundQty(this);
		});

		return this;
	}

	instance.hideTables = function(res){
		if(res.invoiced_shipped == ''){
			jQuery("#invoice_overlay .overlay-body #inv_ship").addClass('hidden');
			jQuery("#invoice_overlay .overlay-body .carrier-tracking").addClass('hidden');
		}/* else{
			jQuery("#invoice_overlay .overlay-body #inv_ship").removeClass('hidden');
			jQuery("#invoice_overlay .overlay-body .carrier-tracking").removeClass('hidden');
		}*/

		// if(res.ordered_invoiced == ''){
		// 	jQuery("#invoice_overlay .overlay-body #ord_inv").addClass('hidden');
		// } else{
		// 	jQuery("#invoice_overlay .overlay-body #ord_inv").removeClass('hidden');
		// }
	}

	instance.shipButtonStatus = function(){
		jQuery(".refund_order_item_qty").each(function(){
			var invQty = jQuery(this).closest("tr.item").find(".i-qty").html();
			invQty = isNaN(invQty) ? 0 : parseInt(invQty);
			var refQty = jQuery(this).closest("tr.item").find(".r-qty").html();
			refQty = isNaN(refQty) ? 0 : parseInt(refQty);
			var disQty = jQuery(this).closest("tr.item").find(".d-qty").html();
			disQty = isNaN(disQty) ? 0 : parseInt(disQty);
			if(invQty <= (disQty - refQty)){
				jQuery(".ship_invoice#cus_ship").addClass("disabled");
				jQuery(".ship_invoice#cus_ship").attr("disabled". true);
			}
			return false;	
		});
	}
	instance.refundCheck = function(){
		var o_status = jQuery("#order_status").val();
		if(o_status !== 'wc-refunded' && o_status !== 'wc-cancelled'){
			instance.all_refunded = instance.checkRefundedTotal();
			if(instance.all_refunded){
				var data = {
					action 		: "woocommerce_all_items_refunded",
					my_order_id	: instance.order_id
				};
				jQuery.post(ajaxurl, data, function(res){
					if(res){
						jQuery( '#woocommerce-order-items' ).unblock();
						location.reload();
					}else{
						alert("Request couldn't be completed!");
					}
				});
			}
		}
	}

	instance.completedCheck = function(){
		var o_status = jQuery("#order_status").val();
		if(o_status !== 'wc-completed' && o_status !== 'wc-refunded' && o_status !== 'wc-cancelled'){
			instance.all_done = instance.checkAllTotal();
			if(instance.all_done){
				var data = {
					action 		: "woocommerce_all_items_done",
					my_order_id	: instance.order_id
				};
				jQuery.post(ajaxurl, data, function(res){
					if(res){
						jQuery( '#woocommerce-order-items' ).unblock();
						location.reload();
					}else{
						alert("Request couldn't be completed!");
					}
				});
			}
		}
	}

	instance.checkAllTotal = function(){
		var all_done = true;
		jQuery("#order_line_items .item_status").each(function(){
			var o_qty = parseInt(jQuery(".o-qty", this).html());
			var r_qty = parseInt(jQuery(".r-qty", this).html());
			r_qty = isNaN(r_qty) ? 0 : r_qty;
			var d_qty = parseInt(jQuery(".d-qty", this).html());
			d_qty = isNaN(d_qty) ? 0 : d_qty;
			if(!((!isNaN(o_qty)) && o_qty <= r_qty + d_qty)){
				all_done = false;
				return false;
			}
		});
		return all_done;
	}

	instance.checkRefundedTotal = function(){
		var all_refunded = true;
		jQuery("#order_line_items .item_status").each(function(){
			var o_qty = parseInt(jQuery(".o-qty", this).html());
			var r_qty = parseInt(jQuery(".r-qty", this).html())
			if(!((!isNaN(o_qty)) && o_qty === r_qty)){
				all_refunded = false;
				return false;
			}
		});
		return all_refunded;
	}

	instance.validateRefundQty = function(ref){
		var maxQty = parseInt(jQuery(ref).attr('max'));
		var newQty = parseInt(jQuery(ref).val());
		var invQty = jQuery(ref).closest("tr.item").find(".i-qty").html();
		var refQty = jQuery(ref).closest("tr.item").find(".r-qty").html();
		invQty = invQty ? parseInt(invQty) : 0 ;
		refQty = refQty ? parseInt(refQty) : 0 ;
		var diff= maxQty - refQty;
		if(newQty < diff ){
			diff= newQty;
		}
		// console.log('diff', diff, 'newQty', newQty, 'refQty', refQty, 'invQty', invQty);
		if(newQty > diff || newQty < 0 || newQty > maxQty){
		jQuery(ref).val(diff).trigger('change');
			}
		}

	instance.hideShippingHtml = function(){
		//shop_order Totals
		jQuery("#postbox-container-2 #woocommerce-order-items .inside .wc-order-totals-items table.wc-order-totals tr:first").addClass("hidden");
	}

	instance.disableButtons = function(){
		var status = jQuery("#order_status").val();
		if(status !== "wc-processing" && status !== "wc-completed" && status !=="wc-on-hold")
		{
			jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items button.refund-items").attr('disabled','disabled');
	     	jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items button.refund-items").addClass('disabled');
		}
		if(status !== "wc-processing"){
			jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items a.edit-invoice#cus_invoice").attr('disabled','disabled');
			jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items a.edit-invoice#cus_invoice").addClass('disabled');
			jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items a.ship_invoice#cus_ship").attr('disabled','disabled');
			jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items a.ship_invoice#cus_ship").addClass('disabled');
		}

		jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items button.add-line-item").addClass("hidden");
		jQuery("#postbox-container-2 .wc-order-bulk-actions .add-items button.add-coupon").addClass("hidden");
	}	

	instance.selectToInvoice = function(){
		jQuery("#invoice_overlay #inner .overlay-body table#inv_ship .ship_status").each(function(){
			jQuery(this).prop('checked',false);
		});
		jQuery("#invoice_overlay #inner .overlay-body table#ord_inv .invoice_status").each(function(){
			jQuery(this).prop('checked',true);
		});
		jQuery("#invoice_overlay #inner .overlay-footer .button.create_invoice.only_invoice").removeClass('hidden');
		jQuery("#invoice_overlay #inner .overlay-footer .button.create_invoice.ship_as_well").addClass('hidden');
		jQuery("#invoice_overlay .overlay-body .carrier-tracking").addClass('hidden');
		jQuery("#invoice_overlay #inner .overlay-body table#ord_inv").removeClass('hidden');
		jQuery("#invoice_overlay #inner .overlay-body table#inv_ship").addClass('hidden');

		jQuery(".invoice_status").click();
	}


	instance.create_rows = function(res){
		jQuery("#invoice_overlay #inner .overlay-body table#ord_inv tbody").html(res.ordered_invoiced);
		jQuery("#invoice_overlay #inner .overlay-body table#inv_ship tbody").html(res.invoiced_shipped);
		instance.validate_invoice_quantity();
		instance.handleCheckBoxes();
	}

	instance.validate_invoice_quantity = function(){
		jQuery("#invoice_overlay #inner .for_invoice, #invoice_overlay #inner .for_invoice2").on('keyup', function(){
			var upperLimit = parseInt(jQuery(this).attr('upperLimit'));
			var now_value = parseInt(jQuery(this).val());
			if(isNaN(now_value) || now_value > upperLimit || now_value < 0){
				jQuery(this).addClass("invalid_qty");
				jQuery("#invoice_overlay #inner .overlay-footer").addClass("hidden");
			} else{	
				jQuery(this).removeClass("invalid_qty");
				jQuery("#invoice_overlay #inner .overlay-footer").removeClass("hidden");
			}
		});
	}

	instance.handleCheckBoxes = function(){
		jQuery("#invoice_overlay #inner .overlay-body table#ord_inv .invoice_status").on('click', function(){
			jQuery("#invoice_overlay #inner .overlay-body table#inv_ship .ship_status").each(function(){
				jQuery(this).prop('checked', false);
			});

			jQuery("#invoice_overlay #inner .overlay-body .carrier-tracking select, #invoice_overlay #inner .overlay-body .carrier-tracking input").attr('disabled', 'disabled');

			instance.handleClick('order');
		});

		jQuery("#invoice_overlay #inner .overlay-body table#inv_ship .ship_status").on('click', function(){
			jQuery("#invoice_overlay #inner .overlay-body table#ord_inv .invoice_status").each(function(){
				jQuery(this).prop('checked', false);
			});
			
			jQuery("#invoice_overlay #inner .overlay-body .carrier-tracking select, #invoice_overlay #inner .overlay-body .carrier-tracking input").attr('disabled', false);

			instance.handleClick('invoice');
		});

		// jQuery("#invoice_overlay #inner .overlay-body table#inv_ship .item_status2 input").on('click', function(){
		// 	instance.handleClick('invoice');
		// });



		jQuery("#invoice_overlay #inner .overlay-body table#ord_inv .item_status input, #invoice_overlay #inner .overlay-body table#ord_inv th .invoice_all_items").on('click', function(){
			instance.hideInvoiceButton();
		});
		jQuery("#invoice_overlay #inner .overlay-body table#ord_inv .item_status input, #invoice_overlay #inner .overlay-body table#ord_inv th .ship_all_items").on('click', function(){
			instance.hideInvoiceButton();
		});
	}

	instance.handleClick = function(table){
		var table_id = (table == 'order') ? 'ord_inv': 'inv_ship';
		var td_class = (table == 'order') ? 'item_status' : 'item_status2';
		var cb_class = (table == 'order') ? 'invoice_all_items' : 'ship_all_items';
		var i = 0;
		jQuery("#invoice_overlay #inner .overlay-body table#"+table_id+" ."+td_class).each(function(){
			if(jQuery("input",this).prop('checked')) {
				i++;
			}
		});
		if(i == jQuery("#invoice_overlay #inner .overlay-body table#"+table_id+" ."+td_class).length){
			jQuery("#invoice_overlay #inner .overlay-body table th ."+cb_class).prop('checked', true);
		} else{
			jQuery("#invoice_overlay #inner .overlay-body table th ."+cb_class).prop('checked', false);
		}
		instance.hideShipmentButton();
	}

	instance.hideInvoiceButton = function(){
		if(!jQuery("#inv_ship").hasClass("hidden")){
			var i = 0;
			jQuery("#invoice_overlay #inner .invoice_item").each(function(){
				if(jQuery(this).prop('checked')) {
					i++;
				}
			});
			if(!(i || jQuery("#invoice_overlay #inner .invoice_all_items").prop('checked'))){
				jQuery("#invoice_overlay #inner .overlay-footer .only_invoice").attr("disabled", "disabled");
			} else{
				jQuery("#invoice_overlay #inner .overlay-footer .only_invoice").attr("disabled", false);
			}
		}
		instance.hideShipmentButton();
	}

	instance.hideShipmentButton = function(){
		var sel = 0;
		jQuery("#invoice_overlay #inner .invoice_item").each(function(){
			if(jQuery(this).prop('checked')) {
				sel++;
			}
		});
		if(sel > 0){
			jQuery("#invoice_overlay #inner .overlay-footer .ship_as_well").attr("disabled", "disabled");
			
			// jQuery("#invoice_overlay #inner .invoice_item2").each(function(){
			// 	jQuery(this).prop('checked', false);
			// });
			// jQuery("#invoice_overlay #inner .overlay-body table th .ship_all_items").prop('checked', false);

		}else{
			jQuery("#invoice_overlay #inner .overlay-footer .ship_as_well").attr("disabled", false);
		}
		var sel2 = 0;
		jQuery("#invoice_overlay #inner .invoice_item2").each(function(){
			if(jQuery(this).prop('checked')) {
				sel2++;
			}
		});
		if(sel2 > 0){
			jQuery("#invoice_overlay #inner .overlay-footer .only_invoice").attr("disabled", "disabled");
			
			// jQuery("#invoice_overlay #inner .invoice_item").each(function(){
			// 	jQuery(this).prop('checked', false);
			// });
			// jQuery("#invoice_overlay #inner .overlay-body table th .invoice_all_items").prop('checked', false);

		}else{
			jQuery("#invoice_overlay #inner .overlay-footer .only_invoice").attr("disabled", false);
		}
	}

	return instance;
}
	
	



	

