<?php

if ( ! defined( 'ABSPATH' ) ) {
	echo "Silence is Golden.";
	die; // Exit if accessed directly
}

class Quivers_Route_Register { //Class Begins

	public $table_name = "woocommerce_order_invoice_details";

	function __construct(){
		add_action( 'rest_api_init', array($this, 'wpc_register_wp_api_endpoints' ));
	}

	function wpc_register_wp_api_endpoints() {

		register_rest_route( 'wc/v2', '/orders/(?P<order_id>[\d]+)/refunds', array(
			'methods' => 'POST',
			'callback' => array( $this ,'wpc_refund_callback'),
			'permission_callback' => array( $this, 'create_item_permissions_check' ),
		), true);

		register_rest_route( 'wc/v2', '/invoice/(?P<order_id>[\d]+)', array(
			'methods' => 'GET',
			'callback' => array( $this ,'get_invoice_details'),
			'permission_callback' => array( $this, 'get_item_permissions_check' ),
		), false);

		register_rest_route( 'wc/v2', '/shipment/(?P<order_id>[\d]+)', array(
			'methods' => 'GET',
			'callback' => array( $this ,'get_shipment_details'),
			'permission_callback' => array( $this, 'get_item_permissions_check' ),
		), false);

		register_rest_route( 'wc/v2', '/invoice', array(
			'methods' => 'GET',
			'callback' => array( $this ,'get_all_invoices'),
			'permission_callback' => array( $this, 'get_item_permissions_check' ),
		), false);

		register_rest_route( 'wc/v2', '/shipment', array(
			'methods' => 'GET',
			'callback' => array( $this ,'get_all_shipments'),
			'permission_callback' => array( $this, 'get_item_permissions_check' ),
		), false);

		register_rest_route( 'wc/v2', '/invoice/(?P<order_id>[\d]+)', array(
			'methods' => 'POST',
			'callback' => array( $this ,'save_invoice_details'),
			'permission_callback' => array( $this, 'create_item_permissions_check' ),
		), false);

		register_rest_route( 'wc/v2', '/shipment/(?P<order_id>[\d]+)', array(
			'methods' => 'POST',
			'callback' => array( $this ,'save_shipment_details'),
			'permission_callback' => array( $this, 'create_item_permissions_check' ),
		), false);

		register_rest_route( 'wc/v2', '/quivers/products', array(
			'methods' => 'GET',
			'callback' => array( $this ,'wpc_quivers_products_callback'),
			'permission_callback' => array( $this, 'create_item_permissions_check' )
		), true);

		register_rest_route( 'wc/v2', '/quivers/setting', array(
			'methods' => 'GET',
			'callback' => array( $this ,'wpc_quivers_setting_callback'),
			'permission_callback' => array( $this, 'get_item_permissions_check' )
		), true);

		register_rest_route( 'wc/v2', '/quivers/update_order_id', array(
			'methods' => 'Post',
			'callback' => array( $this ,'wpc_Update_quivers_order_id'),
			'permission_callback' => array( $this, 'get_item_permissions_check' ),
		), true);

	}

	function wpc_Update_quivers_order_id( $request){
		try{
			$body = json_decode($request->get_body(),true);
			$order = wc_get_order($body['client_order_id'] );
			$order->update_meta_data('quivers_order_id',$body['quivers_order_id']);
			$order ->save(); 
			return $body;
		 }
		 catch(Exception $e) {
			return  'Message: ' .$e->getMessage();
		 }
		}

	function wpc_quivers_setting_callback($request) {

        $timezone_string = "";
        $timezone_string = get_option( 'timezone_string');
        $offset  = (float) get_option( 'gmt_offset' );   
		     
        $hours   = (int) $offset;
        $minutes = ( $offset - $hours );
        $sign      = ( $offset < 0 ) ? '-' : '+';
        $abs_hour  = abs( $hours );
        $abs_mins  = abs( $minutes * 60 );
        
		if(!$timezone_string){
        $timezone_string = "UTC".$sign . $abs_hour . ":" . $abs_mins;
        }
        
		$tz_offset = sprintf( '%s%02d:%02d', $sign, $abs_hour, $abs_mins );
        $websites = ["timezone" => $timezone_string,"utc_offset" =>  $tz_offset];
		return $websites;
	}	

	function wpc_quivers_products_callback($request) {
		global $wpdb;
		$table_name = $wpdb->prefix . 'posts';
		$sql  = "SELECT * FROM $table_name WHERE post_type = 'product' && post_status = 'publish'";
		if (!empty($request->get_params()['last_modified'])){
			$last_modified_date = $request->get_params()['last_modified'];
			$sql = $sql. " && post_modified >= '$last_modified_date' order by post_modified DESC";
		}
		if (!empty($request->get_params()['per_page']) && !empty($request->get_params()['per_page'])){
			$per_page = $request->get_params()['per_page'];
			$page = $request->get_params()['page'];
			$page = $page - 1;
			if ($page != 0){
				$page = ($per_page * $page);
			}
			$sql = $sql. " LIMIT $per_page OFFSET $page";
		}
		$results = $wpdb->get_results( $sql, OBJECT );
		return $results;
	

	}

	function save_invoice_details($request) {

		$id = is_numeric($request['order_id']) ? $request['order_id'] : 0;

		if($id){
			global $woo_cancel;
			$items_added = $woo_cancel->calculate_upper_limit_2($id);

			$data = $this->get_data_invoice($request, "false", $items_added);

			if(isset($data['status']) && !$data['status']){
				return $data['reason'];
			} else{
				$insert = $this->insert_data($data);
				if($insert){
					do_action('quivers_order_invoiced', $id, $insert['lastid']);
					return $insert;
				}
			}
			
			
		}	

	}

	function save_shipment_details($request) {
		$id = is_numeric($request['order_id']) ? $request['order_id'] : 0;

		if($id){
			global $woo_cancel;
			$shipped_qty = $woo_cancel->calculate_dispatched_qty($id);
			$invoiced = $woo_cancel->calculate_upper_limit_2($id);

			$data = $this->get_data_shipped($request, "true", $shipped_qty, $invoiced);

			if(isset($data['status']) && !$data['status']){
				return $data['reason'];
			} else{
				$insert = $this->insert_data($data);
				if($insert){
					do_action('quivers_order_shipped', $id, $insert['lastid']);
					return $insert;					
				} 
			}
			
			
		}
	}

	function insert_data($data){
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;

		$res = $wpdb->insert($table_name, $data);
		$lastid = $wpdb->insert_id;
		if($res) return array("id" => $lastid);
		else return 'false';
	}

	function get_data_shipped($request, $shipped, $shipped_qty, $invoiced){
		if(!isset($request['products'])){
			return $this->get_valid_response(false, 'product required');
		}
		if(!isset($request['carrier'])){
			return $this->get_valid_response(false, 'carrier required');
		}
		$order = new WC_Order($request['order_id']);
		$items = $order->get_items();
		
		$items_details = [];
		foreach ($items as $key => $item) {
			$items_details['item_key'][$item['product_id']][$item['variation_id']] = $key;
			$items_details['key'][$key] = array("p_id"=>$item['product_id'], "v_id"=>$item['variation_id']); 
			$items_details['item_id'][] = $item['product_id'];
			$items_details['check_id'][] = $key;
			$items_details['name'][$key] = $item['name'];
			$items_details['qty'][$key] = $item['quantity'];
			$items_details['total'][$key] = $item->get_total();
		}
		$data = [];
		$data['order_id'] = $request['order_id'];
		foreach ($request['products'] as $product) {
			if(!isset($product['item_id']) || !isset($product['shipped_qty'])){
				return $this->get_valid_response(false, 'item_id,shipped_qty are required');
			}
			$validated = $this->validate_data_shipped($product , $request);

			if(isset($validated['status']) && !$validated['status']){
				return $validated;
			}
			if(!in_array($product['item_id'], $items_details['check_id'])){
				return $this->get_valid_response(false, 'item not in order');
			}

			$product_id = $items_details['key'][$product['item_id']]['p_id'];
			$variation_id = $items_details['key'][$product['item_id']]['v_id'];
			$ref_qty = $order->get_qty_refunded_for_item($items_details['item_key'][$product_id][$variation_id]);
			
			if($product['shipped_qty'] > (@$invoiced[$items_details['name'][$product['item_id']]][$product_id][$variation_id] - @$shipped_qty[$items_details['name'][$product['item_id']]][$product_id][$variation_id] - absint(@$ref_qty) )){
				return $this->get_valid_response(false, 'incorrect ship quantity.');
			}
			if($product['shipped_qty'] > 0 ){
				$data['products'][] = array(
					"item_name" => (string)$items_details['name'][$product['item_id']],
					"item_id" => (string)$items_details['key'][$product['item_id']]['p_id'],
					"variation_id" => (string)$items_details['key'][$product['item_id']]['v_id'],
					"item_qty" => (string)$items_details['qty'][$product['item_id']],
					"invoiced_qty" => (string)$product['shipped_qty'],
					"item_total" => (string)$items_details['total'][$product['item_id']],
				);
			} else{
				return $this->get_valid_response(false, 'invoice quantity can\'t be or less than 0.');
			}

		}
		$data['products'] = json_encode($data['products']);
		$data['carrier'] = (string)$request['carrier'];
		$data['tracking_number'] = (string)$request['tracking_number'];
		$data['shipped'] = (string)$shipped;
		return $data;
	}

	function get_data_invoice($request, $shipped, $items_added){
		// global $woocommerce;
		
		$order = new WC_Order($request['order_id']);
		$items = $order->get_items();
		
		$items_details = [];
		foreach ($items as $key => $item) {
			$items_details['key'][$key] = array("p_id"=>$item['product_id'], "v_id"=>$item['variation_id']); 
			$items_details['item_id'][] = $item['product_id'];
			$items_details['check_id'][] = $key;
			$items_details['name'][$key] = $item['name'];
			$items_details['qty'][$key] = $item['quantity'];
			$items_details['total'][$key] = $item->get_total();
		}

		$data = [];
		$data['order_id'] = $request['order_id'];
		
		foreach ($request['products'] as $product) {
			if(!isset($product['item_id']) || !isset($product['invoiced_qty'])){
				return $this->get_valid_response(false, 'item_id,invoiced_qty are required');
			}
			$validated = $this->validate_data_invoice($product , $request);
			
			if(isset($validated['status']) && !$validated['status']){
				return $validated;
			}
			if(!in_array($product['item_id'], $items_details['check_id'])){
				return $this->get_valid_response(false, 'item not in order');
			}

			$product_id = $items_details['key'][$product['item_id']]['p_id'];
			$variation_id = $items_details['key'][$product['item_id']]['v_id'];

			if($product['invoiced_qty'] > ($items_details['qty'][$product['item_id']] - @$items_added[$items_details['name'][$product['item_id']]][$product_id][$variation_id])){
				return $this->get_valid_response(false, 'incorrect invoice quantity.');
			}
			if($product['invoiced_qty'] > 0 ){
				$data['products'][] = array(
					"item_name" => (string)$items_details['name'][$product['item_id']],
					"item_id" => (string)$items_details['key'][$product['item_id']]['p_id'],
					"variation_id" => (string)$items_details['key'][$product['item_id']]['v_id'],
					"item_qty" => (string)$items_details['qty'][$product['item_id']],
					"invoiced_qty" => (string)$product['invoiced_qty'],
					"item_total" => (string)$items_details['total'][$product['item_id']],
				);
			} else{
				return $this->get_valid_response(false, 'invoice quantity can\'t be or less than 0.');
			}


		}
		$data['products'] = json_encode($data['products']);
		$data['carrier'] = (string)$request['carrier'];
		$data['tracking_number'] = (string)$request['tracking_number'];
		$data['shipped'] = (string)$shipped;
		return $data;
	}

	function get_invoice_details($request) {

		$id = is_numeric($request['order_id']) ? $request['order_id'] : 0;
		if($id){
			global $wpdb;
			$table_name = $wpdb->prefix . $this->table_name;
			$result = $wpdb->get_results("select id,order_id,products from $table_name where shipped != 'true' && order_id = $id", ARRAY_A);
			$output = [];
			foreach ($result as $invoice) {
				$invoice['products'] = json_decode($invoice['products'], true);
				$datum = array();
				foreach ($invoice['products'] as $value) {
					$datum[] = array(
							"item_name" => $value['item_name'],
							"item_id" => $value['in_order_item_id'],
							"item_qty" => $value['item_qty'],
							"invoiced_qty" => $value['invoiced_qty'],
							"item_total" => $value['item_total'],
						);
				}

				$invoice['products'] = $datum;

				$output[] = $invoice;
			}
			return $output;
		} else{
			return 'Please enter a valid integer id.';
		}

	}

	function get_shipment_details($request) {

		$id = is_numeric($request['order_id']) ? $request['order_id'] : 0;
		if($id){
			global $wpdb;
			$table_name = $wpdb->prefix . $this->table_name;
			$result = $wpdb->get_results("select id,order_id,products,carrier,tracking_number from $table_name where shipped = 'true' && order_id = $id", ARRAY_A);
			$output = [];
			foreach ($result as $shipment) {
				$shipment['products'] = json_decode($shipment['products'], true);
				$datum = array();
				foreach ($shipment['products'] as $value) {
					$datum[] = array(
							"item_name" => $value['item_name'],
							"item_id" => $value['in_order_item_id'],
							"item_qty" => $value['item_qty'],
							"shipped_qty" => $value['invoiced_qty'],
							"item_total" => $value['item_total'],
						);
				}

				$shipment['products'] = $datum;

				$output[] = $shipment;
			}
			return $output;
		} else{
			return 'Please enter a valid integer id.';
		}

	}

	function get_all_invoices($request){
		// $id = is_numeric($request['order_id']) ? $request['order_id'] : 0;
		// if($id){
			global $wpdb;
			$table_name = $wpdb->prefix . $this->table_name;
			$result = $wpdb->get_results("select id,order_id,products,carrier,tracking_number from $table_name where shipped != 'true' order by order_id", ARRAY_A);
			$output = [];
			foreach ($result as $invoice) {
				$invoice['products'] = json_decode($invoice['products'], true);
				$datum = array();
				foreach ($invoice['products'] as $value) {
					$datum[] = array(
							"item_name" => $value['item_name'],
							"item_id" => $value['in_order_item_id'],
							"item_qty" => $value['item_qty'],
							"invoiced_qty" => $value['invoiced_qty'],
							"item_total" => $value['item_total'],
						);
				}

				$invoice['products'] = $datum;

				$output[] = $invoice;
			}
			return $output;
		// } else{
			// return 'Please enter a valid integer id.';
		// }
	}
	
	function get_all_shipments($request){
		// $id = is_numeric($request['order_id']) ? $request['order_id'] : 0;
		// if($id){
			global $wpdb;
			$table_name = $wpdb->prefix . $this->table_name;
			$last_modified_date = $request->get_params()['last_modified'];
			$result = $wpdb->get_results("select id,order_id,products,carrier,tracking_number,time from $table_name where shipped = 'true' && time >= '$last_modified_date' order by order_id", ARRAY_A);
			$output = [];
			foreach ($result as $shipment) {
				$shipment['products'] = json_decode($shipment['products'], true);
				$datum = array();
				foreach ($shipment['products'] as $value) {
					$datum[] = array(
							"item_name" => $value['item_name'],
							"item_id" => $value['in_order_item_id'],
							"item_qty" => $value['item_qty'],
							"shipped_qty" => $value['invoiced_qty'],
							"item_total" => $value['item_total'],
						);
				}

				$shipment['products'] = $datum;

				$output[] = $shipment;
			}
			return $output;
		// } else{
			// return 'Please enter a valid integer id.';
		// }
	}

	function get_valid_response($status, $reason){
		return array(
				'status' => $status,'reason' => $reason
			);
	}

	function validate_data_invoice($product, $request){
		
		if('string' == gettype($product['item_id']) || 'integer' == gettype($product['item_id'])){

		} else{			
			return $this->get_valid_response(false, 'item_id is invalid .');
		}
		if('string' == gettype($product['invoiced_qty']) || 'integer' == gettype($product['invoiced_qty'])){

		} else{			
			return $this->get_valid_response(false, 'invoiced_qty is invalid .');
		} 
		
		// if('string' != gettype($request['tracking_number'])){
		// 	return $this->get_valid_response(false, 'tracking_number is invalid .');
		// }
		// if('string' != gettype($request['carrier'])){
		// 	return $this->get_valid_response(false, 'carrier should be string .');
		// }
	
	}

	function validate_data_shipped($product, $request){
		
		if('string' == gettype($product['item_id']) || 'integer' == gettype($product['item_id'])){

		} else{			
			return $this->get_valid_response(false, 'item_id is invalid .');
		}
		if('string' == gettype($product['shipped_qty']) || 'integer' == gettype($product['shipped_qty'])){

		} else{			
			return $this->get_valid_response(false, 'shipped_qty is invalid .');
		} 
		
		if('string' != gettype($request['carrier'])){
			return $this->get_valid_response(false, 'carrier should be string .');
		}
	
	}

	function get_object( $id ) {
		// translators: %s: Class method name.
		return new WP_Error( 'invalid-method', sprintf( __( "Method '%s' not implemented. Must be overridden in subclass.", 'woocommerce' ), __METHOD__ ), array( 'status' => 405 ) );
	}


	function wpc_refund_callback( $request, $creating = false ) {
		$order = wc_get_order( (int) $request['order_id'] );

		if ( ! $order ) {
			return new WP_Error( 'woocommerce_rest_invalid_order_id', __( 'Invalid order ID.', 'woocommerce' ), 404 );
		}

		if ( 0 > $request['amount'] ) {
			return new WP_Error( 'woocommerce_rest_invalid_order_refund', __( 'Refund amount must be greater than zero.', 'woocommerce' ), 400 );
		}
		$refund_restock_item =get_option('wc_settings_tab_demo_restock_refund_status');
		$refund_restock_item =filter_var($refund_restock_item, FILTER_VALIDATE_BOOLEAN);
		// $refund_reason = "Order Cancelled";
		// Create the refund.
		$refund = wc_create_refund(
			array(
				'order_id'       => $order->get_id(),
				'amount'         => $request['amount'],
				'reason'         => empty( $request['reason'] ) ? null : $request['reason'],
				'refund_payment' => is_bool( $request['api_refund'] ) ? $request['api_refund'] : true,
				'line_items'	 => empty( $request['line_items'] ) ? array() : $request['line_items'],
				'restock_items'  => $refund_restock_item,
			)
		);

		if ( is_wp_error( $refund ) ) {
			return new WP_Error( 'woocommerce_rest_cannot_create_order_refund', $refund->get_error_message(), 500 );
		}

		if ( ! $refund ) {
			return new WP_Error( 'woocommerce_rest_cannot_create_order_refund', __( 'Cannot create order refund, please try again.', 'woocommerce' ), 500 );
		}

		if ( ! empty( $request['meta_data'] ) && is_array( $request['meta_data'] ) ) {
			foreach ( $request['meta_data'] as $meta ) {
				$refund->update_meta_data( $meta['key'], $meta['value'], isset( $meta['id'] ) ? $meta['id'] : '' );
			}
			$refund->save_meta_data();
		}

		apply_filters( "woocommerce_rest_pre_insert_shop_order_refund_object", $refund, $request, $creating );


		
		return  array(
			'id'               => $refund->get_id() ? $refund->get_id() : '',
			'amount'		   => $refund->get_amount() ? $refund->get_amount() : '',
			'reason'		   => $refund->get_reason() ? $refund->get_reason() : '',
			'refunded_by'	   => $refund->get_refunded_by() ? $refund->get_refunded_by() : '',
		); 
	}

	function get_item_permissions_check( $request ) {
		$post = get_post( (int) $request['id'] );

		if ( $post && ! wc_rest_check_post_permissions( $this->post_type, 'read', $post->ID ) ) {
			return new WP_Error( 'woocommerce_rest_cannot_view', __( 'Sorry, you cannot view this resource.', 'woocommerce' ), array( 'status' => rest_authorization_required_code() ) );
		}

		return true;
	}

	function create_item_permissions_check($request){
		if ( ! wc_rest_check_post_permissions( 'shop_order_refund', 'create' ) ) {
			return new WP_Error( 'woocommerce_rest_cannot_create', __( 'Sorry, you are not allowed to create resources.', 'woocommerce' ), array( 'status' => rest_authorization_required_code() ) );
		}

		return true;
	}
	
}

// finally instantiate our plugin class and add it to the set of globals
if( class_exists("Quivers_Route_Register") ) $GLOBALS['quivers_route_register'] = new Quivers_Route_Register();

// to pull in dimensions and weight units.
add_filter('woocommerce_rest_prepare_product_variation_object', 'add_dimention_units_product_response', 20, 3);
 
add_filter( 'woocommerce_rest_prepare_product_object', 'add_dimention_units_product_response', 20, 3 );

function add_dimention_units_product_response($response,$object,$request) {
   $response->data['quivers_weight_unit'] = get_option('woocommerce_weight_unit');
   $response->data['quivers_dimension_unit'] = get_option('woocommerce_dimension_unit');
   return $response;
}
?>
