<?php

class My_WC_LogTracking
{
	protected $logEndpoint = 'logs/';

    public function session_start($order_detail, $time){
        $logData = [
            "order_detail" => $order_detail,
            "time" => $time
        ];
         $this->logging("SESSION START", $logData);
    }

    public function validate_api_call($request, $response, $start_time, $end_time){
        $logData = [
            "start_time" => $start_time,
            "end_time" => $end_time,
            "request" => $request,
            "response" => $response
        ];
        $this->logging("VALIDATE API CALL", $logData);
    }
    public function captcha_data($siteVerifyResponse, $token ,$captcha_response){
        $logData = [
                "site_verify_response" => $siteVerifyResponse,
                "token" => $token,
                "captcha_response" => $captcha_response
            ];
        $this->logging("CAPTCHA RESPONSE", $logData);
    }
    public function countries_api_call($request, $response, $start_time, $end_time){
     $logData = [
            "request" => $request,
            "response" => $response,
            "start_time" => $start_time,
            "end_time" => $end_time
        ];
     $this->logging("COUNTRIES API CALL", $logData);
    }

    public function request_data($request){
    $logData = [
            "request_data" => $request
        ];
    $this->logging("REQUEST DATA", $logData);
    }

    public function statement_descriptor_log($statement_descriptor){
    $logData = [
            "statement_descriptor_suffix" => $statement_descriptor
        ];
    $this->logging("STATEMENT DESCRIPTOR", $logData);
    }

    public function payment_request($order_data, $payment_method, $time, $response, $success,$request,$intent){
     $logData = [
            "order_data" => $order_data,
            "payment_method" => $payment_method,
            "time" => $time,
            "response" => $response,
            "success" => $success,
            "request"=>$request,
            "intent"=>$intent
        ];
     $this->logging("PAYMENT REQUEST", $logData);
    }

    public function payment_complete($data){
        $logData = [
        "payment_complete" => $data
        ];
        $this->logging("PAYMENT COMPLETE", $logData);
    }

    public function wc_add_fee($validate_response,$fee_add, $fee_included, $time){
    $logData = [
            "validate_response" => $validate_response,
            "tax_fee_add" => $fee_add,
            "tax_fee_included" => $fee_included,
            "time" => $time

    ];
      $this->logging("WC ADD FEE", $logData);
    }

    public function validate_order_action($request, $response, $start_time, $end_time){
    $logData = [
            "start_time" => $start_time,
            "end_time" => $end_time,
            "request" => $request,
            "response" => $response
        ];
    $this->logging("ORDER STATUS VALIDATE", $logData);

    }
    public function debug_mode($function_name, $unique_string, $data, $email,$request, $response){
      
        $logData = [   
            
            "Function name" => $function_name,
            "Unique string" => $unique_string,
            "Data" => $data,
            "Email" => $email,
            "Request" => $request,
            "Response" => $response
            
        ];
        
        $this->logging("DEBUG MODE WOOCOMMERCE", $logData);
    
        }
    public function session_end($order_detail, $time){
     $logData = [
            "order_detail" => $order_detail,
            "time" => $time
        ];
     $this->logging("SESSION END", $logData);
    }

    public function order_status($status, $time){
        $logData = [
               "status" => $status,
               "time" => $time
           ];
        $this->logging("Status Activity", $logData);
    }
    public function print_error($result, $time){
        $logData = [
               "result" => $result,
               "time" => $time
           ];
        $this->logging("Settings  Activity", $logData);
    }

   	public function logging($type, $data)
    {
      
        $quivers_sandbox = get_option('wc_settings_tab_demo_sandbox_status');
        $baseUrl = 'https://middleware.quiversdemo.com/profile/';
        if($quivers_sandbox == 'no') {
            $baseUrl = 'https://middleware.quivers.com/profile/';
        }
        $quiversAPIKey = get_option('wc_settings_tab_demo_apikey');
        $logdata = [
    		"api_key" => "apiKey ".$quiversAPIKey,
    		"uuid" => uniqid(),
            "type" => $type,
    		"log_data" => $data
    	];
    	$logUrl = $baseUrl.$this->logEndpoint;
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$logUrl);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($logdata));
        $output=curl_exec($ch);
        curl_close ($ch);
    }
}