var quivers_stripe = {
  stripe: null,
  card: null,
  token: null,
}

var init_stripe = function() {
  // Create a Stripe client.
  var stripe = Stripe(quivers_stripe_params.publishableKey);
  quivers_stripe.stripe = stripe;
  reset();
  
  // Create an instance of Elements.
  var elements = stripe.elements();

  // Custom styling can be passed to options when creating an Element.
  // (Note that this demo uses a wider set of styles than the guide below.)
  var style = {
    base: {
      color: "#32325d",
      lineHeight: "18px",
      fontFamily: "Helvetica Neue, Helvetica, sans-serif",
      fontSmoothing: "antialiased",
      fontSize: "14px",
      "::placeholder": {
        color: "#aab7c4"
      }
    },
    invalid: {
      color: "#fa755a",
      iconColor: "#fa755a"
    }
  };

  // select biiling post code
  var customPostalCode = document.getElementById('billing_postcode');

  // Create an instance of the card Element with billing address postal code
  var card = elements.create("card", {style: style, hidePostalCode : true, value:{postalCode: customPostalCode.value}});
 
  quivers_stripe.card = card;

  // Add an instance of the card Element into the `card-element` <div>.
  card.mount("#card-element");

  // Handle real-time validation errors from the card Element.
  card.addEventListener("change", function(event) {
    var displayError = document.getElementById("card-errors");
    if (event.error) {
      displayError.textContent = event.error.message;
      reset();
    } else {
      displayError.textContent = '';
    }
  });

  //update postal code in card element
  customPostalCode.addEventListener('change', function(event) {
    card.update({value: {postalCode: event.target.value}});
  });

}

// This function is called when token is generated
function afterTokenCreated(result) {
  if (result.error) {
    // Inform the user if there was an error.
    var errorElement = document.getElementById('card-errors');
    errorElement.textContent = result.error.message;
  } else {
    // Send the token to your server.
    return stripeTokenHandler(result.source);
  }
}

function isQuiversStripeChosen() {
  return jQuery( '#payment_method_quivers_stripe' ).is( ':checked' );
}

var tokenRequest = function() {
  if ( !isQuiversStripeChosen() ) {
        return;
  }
  if (quivers_stripe.token != null) {
    return true;
  }
  quivers_stripe.stripe.createSource(quivers_stripe.card).then(
    afterTokenCreated);
  return false;
};


function reset() {
  jQuery( '.stripe-source' ).remove();
  quivers_stripe.token = null;
}

function stripeTokenHandler(token) {
  var checkout_form = jQuery('form.woocommerce-checkout');
  // Insert the token ID into the form so it gets submitted to the server
  checkout_form.append( "<input type='hidden' class='stripe-source' name='stripe_source' value='" + token.id + "'/>" );
  quivers_stripe.token = token;

  // Submit the form
  checkout_form.submit();
}

jQuery(function($){
  var checkout_form = $( 'form.woocommerce-checkout' );
  checkout_form.on( 'checkout_place_order', tokenRequest);
  $( 'form.woocommerce-checkout' ).on('change',reset);
  $( document )
        .on(
          'checkout_error',
          reload
        );

});
function reload () {
  setTimeout(function() {
    location.reload();
}, 2000);
}
function captchasubmit(event) {    
  jQuery('#place_order').prop('disabled', true);
  jQuery('#place_order').css('opacity', '0.6');
  setTimeout(function(){
          jQuery('#place_order').prop('disabled', false); 
          jQuery('#place_order').css('opacity', '1');             
     }, 2000);
     
    if(jQuery('.g-recaptcha').attr('data-sitekey')=='SITE_KEY_NOT_THERE' ||jQuery('#quivers_captcha').length==0){
      jQuery("form.woocommerce-checkout").trigger('submit');  
    }else {
    if (jQuery("#payment_method_quivers_stripe").is(':checked')==true || jQuery("#payment_method_stripe").is(':checked')==true){
      grecaptcha.execute().then(response => {
        jQuery("form.woocommerce-checkout").trigger('submit'); 
              }).catch(e => {
                       jQuery("form.woocommerce-checkout").trigger('submit'); 
                      });
    
    }else{
    jQuery("form.woocommerce-checkout").trigger('submit');  
    }
  }
 
}

function setResponse() {
   
  var response = grecaptcha.getResponse();
  if(response.length != 0){
          jQuery("form.woocommerce-checkout").trigger('submit');
  } 
}
