<?php

/**
 * Plugin Name: Quivers
 * Description: Used to invoice, override create refunds api, use taxation api, save basic settings, stripe integration.
 * Version: 1.9.4
 * Author: Quivers Inc.
 * Author URI: nitesh.yadav@quivers.com
 * License: GPL2
 */
if ( ! defined( 'ABSPATH' ) ) {
	echo "Silence is Golden.";
	die; // Exit if accessed directly
}

/*
*
** 
Includes*/

/* Handles "Cancel Order" Button and "Invoice" Button */
include_once("cancel_order/cancel_order.php");
include_once('custom-assets.php');
/* Handles "Taxes" and "Quivers Settings" */
include_once("my_wc_cart/my_wc_cart.php");

/* Handles API calls, override routes */
include_once("apis/register_routes.php");
include_once("apis/class-wc-api-resource.php");

/* Handles Stripe Payment Gateway Integration */
include_once("stripe/stripe_gateway.php");

/* Handles PayPal payment integration */
include_once("paypal/woo_paypal.php");

/* handles custom 'On-Hold API call' */
include_once("order_status/my_order_status.php");

/*Handles logs in the plugin*/
include_once("LogTracking.php");

add_filter( 'woocommerce_locate_template', 'myplugin_woocommerce_locate_template', 10, 3 );

function myplugin_woocommerce_locate_template( $template, $template_name, $template_path ) {
  global $woocommerce;

  $_template = $template;

  if ( ! $template_path ) $template_path = $woocommerce->template_url;

  $plugin_path  = untrailingslashit( plugin_dir_path( __FILE__ ) ) . '/woocommerce/';

  // Look within passed path within the theme - this is priority
  $template = locate_template(

    array(
      $template_path . $template_name,
      $template_name
    )
  );

  // Modification: Get the template from this plugin, if it exists
  if ( ! $template && file_exists( $plugin_path . $template_name ) )
    $template = $plugin_path . $template_name;

  // Use default template
  if ( ! $template )
    $template = $_template;
  // Return what we found
  return $template;
}
add_action( 'woocommerce_before_calculate_totals', 'recalc_price' );
function recalc_price( $cart_object ) {
foreach ( $cart_object->get_cart() as $hash => $value ) {
  $type_id = $value['variation_id'] == 0 ? $value['product_id'] : $value['variation_id'];
  $product = wc_get_product( $type_id );
  if($product===false){
    $product = $value['data'];
  }
      $item_price = (float)$product->get_sale_price() ? (float)$product->get_sale_price() : (float)$product->get_price();
      $value['data']->set_price( round($item_price,2));
}
}
add_filter( 'woocommerce_restock_refunded_items', 'woocommerce_restock_refunded_items_quivers' );
 
function woocommerce_restock_refunded_items_quivers( $variable ) {
$variable =get_option('wc_settings_tab_demo_restock_refund_status');
$variable =filter_var($variable, FILTER_VALIDATE_BOOLEAN);
return $variable;
}

add_filter( 'woocommerce_can_reduce_order_stock', 'wcs_do_not_reduce_cancel_stock', 10, 2 );
function wcs_do_not_reduce_cancel_stock( $reduce_stock, $order ) {
    if ($order->has_status( 'wc-refunded')||
    $order->has_status( 'refunded')||
     $order->has_status( 'cancel') ||
      $order->has_status( 'order-cancelled') || $order->has_status( 'cancelled' )
       || $order->has_status('wc-cancelled') ) {
        $refund_restock_item =get_option('wc_settings_tab_demo_restock_refund_status');
	    	$refund_restock_item =filter_var($refund_restock_item, FILTER_VALIDATE_BOOLEAN);
        $reduce_stock = $refund_restock_item;
    }
    return $reduce_stock;
}
add_filter( 'woocommerce_can_restore_order_stock', 'ts_do_not_restock', 10, 2 );
function ts_do_not_restock( $true, $order ){
    $stat  = $order->get_status();
    $refund_restock_item =get_option('wc_settings_tab_demo_restock_refund_status');
    $refund_restock_item =filter_var($refund_restock_item, FILTER_VALIDATE_BOOLEAN);
    $reduce_stock = $refund_restock_item;

    if(($stat == 'cancelled' || $stat == 'wc-cancelled' ||$stat == 'order-cancelled') && $reduce_stock ==false){
        return false;
    }else{
        return true;
    }
}

  //   add_action( 'woocommerce_order_status_processing_to_cancelled', 'restore_order_stock' , 10, 1 );
	// 	add_action( 'woocommerce_order_status_completed_to_cancelled', 'restore_order_stock' , 10, 1 );
	// 	add_action( 'woocommerce_order_status_on-hold_to_cancelled', 'restore_order_stock' , 10, 1 );
	// 	add_action( 'woocommerce_order_status_processing_to_refunded', 'restore_order_stock' , 10, 1 );
	// 	add_action( 'woocommerce_order_status_completed_to_refunded', 'restore_order_stock' , 10, 1 );
	// 	add_action( 'woocommerce_order_status_on-hold_to_refunded', 'restore_order_stock' , 10, 1 );

  // function restore_order_stock( $order_id ) {
  //     $order = new WC_Order( $order_id );
  
  //     if ( ! get_option('woocommerce_manage_stock') == 'yes' && ! sizeof( $order->get_items() ) > 0 ) {
  //       return;
  //     }
  
  //     foreach ( $order->get_items() as $item ) {
  
  //       if ( $item['product_id'] > 0 ) {
  //         $_product = $order->get_product_from_item( $item );
  
  //         if ( $_product && $_product->exists() && $_product->managing_stock() ) {
  
  //           $old_stock = $_product->stock;
  
  //           $qty = apply_filters( 'woocommerce_order_item_quantity', $item['qty'], $this, $item );
  //           $refund_restock_item =get_option('wc_settings_tab_demo_restock_refund_status');
  //           $refund_restock_item =filter_var($refund_restock_item, FILTER_VALIDATE_BOOLEAN);
  //           $reduce_stock = $refund_restock_item;
  //           if($reduce_stock==true){
  //           $new_quantity = $_product->increase_stock( $qty );
  //           do_action( 'woocommerce_auto_stock_restored', $_product, $item );
  //           $order->add_order_note( sprintf( __( 'Stock levels increased from %s to %s.', 'woocommerce' ), $item['product_id'], $old_stock, $new_quantity) );

  //           }
         
  //           $order->send_stock_notifications( $_product, $new_quantity, $item['qty'] );
  //         }
  //       }
  //     }
  //   } // End restore_order_stock()

add_filter('gettext', 'custom_strings_translation', 20, 3);
function custom_strings_translation( $translated_text, $text, $domain ) {
global $pagenow, $typenow;

    // Settings
    $current_text = "Fees:";
    $new_text     = "Estimated Tax:";

    // Targeting admin single order pages
    if( is_admin() && in_array($pagenow, ['post.php', 'post-new.php']) && 'shop_order' === $typenow && $current_text === $text ){
        $translated_text =  __( $new_text, $domain );
    }
    return $translated_text;
}

/*Adds Custom Product Taxcode Field*/
include_once('custom_pdt_taxcode.php');

/*Adds Custom UPC Field*/
include_once('custom_upc_field.php');

/*Handles Pre Order Availability in the plugin*/
include_once("custom_pre_order_availabilty.php");

/*make an API call to mark the profile "off" in the middleware after deactivating the plugin*/
function disable_plugin(){
/* Marking Quivers Integration Settings Active/Inactive status as "Inactive" */
update_option('quivers','Inactive');
$request_data = [
  "client_type" => "Woocommerce",
  "business_refid" => get_option('wc_settings_tab_demo_business_refid'),
  "base_url" => get_option('wc_settings_tab_demo_wp_base_url'),
  "api_key" => get_option('wc_settings_tab_demo_apikey'),
  "consumer_key" => get_option('wc_settings_tab_demo_wp_username'),
  "consumer_secret" => get_option('wc_settings_tab_demo_wp_auth_token'),
  "enable_plugin" => "false"
  ];
  $test = 'demo';
  if(get_option('wc_settings_tab_demo_sandbox_status') == 'no') $test = '';
  $headers = [array('Content-Type:application/json')];
  $curl = curl_init();

  curl_setopt($curl, CURLOPT_POST, 1);
  curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($request_data));

  $url = "https://middleware.quivers" . $test . ".com/profile/create";
  curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10 - 1);
    curl_setopt($curl, CURLOPT_TIMEOUT, 10);
    if ($headers) {
      foreach ($headers as $header) {
        curl_setopt( $curl, CURLOPT_HTTPHEADER, $header);
      }
    }
    $res = [];
    try{
      $result = curl_exec($curl);
    }
    catch(Exception $e) {
      return $res;
    }
 }
register_deactivation_hook(__FILE__, 'disable_plugin');

