jQuery(document).ready(function(){
	var order_status = jQuery('#select2-order_status-container').text();
	jQuery('.save_order').click(function(event) {
		if(order_status == 'On hold'){
			if (confirm('This order is currently available to retailers, claimed by a retailer, or undergoing fraud review. Are you sure you want to proceed with processing this order?')) {
	        	return true;
		    }
		    else{
		    	event.preventDefault();
		        return false;
		    }
		}
	});
	// Handle order item Refunds with jQuery
	jQuery('.refund-items').click(function(event) {
		// make refund-amount field as readonly
		jQuery('#refund_amount').prop('readonly', true);

		jQuery('.wc_input_price').each ( function(){
            jQuery(this).val(0);
        });
		// make tax input field as readonly
		if(jQuery('tbody#order_fee_line_items').find("tr:first").length) {
			var tax_element_name = jQuery('tbody#order_fee_line_items').find("tr:first").find(
			"td.line_cost").find("div.refund").find("input.refund_line_total")[0].name;
			jQuery("input[name='" + tax_element_name + "']:text").prop('readonly', true);
		}

		// refund order item tax for selected qty
		jQuery.ajax( {
			method: 'POST',
			url: ajaxurl,
			data: {
				action : 'order_tax_refund',
				my_order_id	: parseInt(jQuery("input[name='order_id']").val())
			},
			success: function( item_tax_mapping ) {
				for (item in item_tax_mapping) {
					jQuery("input[name='refund_order_item_qty[" + item + "]']").change({mapping: item_tax_mapping, tax_elem: tax_element_name}, function(e) {
						var tax_amount = 0;
						for (item in e.data.mapping) {
							refunded_qty = jQuery("input[name='refund_order_item_qty[" + item + "]']").val();
							var total_item_qty = jQuery('tbody#order_line_items').find("tr[data-order_item_id='" + item + "']").find("td.quantity").find("div.view")[0].textContent.replace("×", "").trim();
							if (refunded_qty === '0') {
								var refunded_amt = 0;
							}
							else {
								var refunded_amt = e.data.mapping[item]/parseInt(total_item_qty)*refunded_qty;
							}
							tax_amount += refunded_amt;
						}
						jQuery("input[name='" + e.data.tax_elem + "']").val(Math.round(tax_amount * 100) / 100);
					});
				}
			},
			error: function(error){
				// do nothing
			}
		});
	});
});