<?php


class My_WC_Cart { //Class Begins

	function __construct(){
		add_action( 'woocommerce_checkout_before_order_review' ,array($this,'so_31413975_extra_checkout_fields') );
		add_action('woocommerce_settings_tabs_array', array($this,'add_tab')); /* Add Tab */
		add_action( 'woocommerce_settings_tabs_quivers_settings', array($this,'load_form') ); /* Load Quivers Form */
		add_action( 'woocommerce_settings_tabs_quivers_tax_settings', array($this,'load_quivers_tax_form') ); /* Load Quivers Tax Form */
		add_action( 'woocommerce_update_options_quivers_settings', array($this, 'update_settings') ); /* Save Settings */
		add_action( 'woocommerce_update_options_quivers_tax_settings', array($this, 'update_tax_settings') ); /* Save Tax Settings */
		add_action( 'woocommerce_cart_calculate_fees', array($this, 'checkout_billing'),999999); /* Tax Calc */
		add_action( 'woocommerce_checkout_create_order_line_item', array($this,'ektgn_meta_to_line_item'), 20, 4 ); 
		add_filter('woocommerce_hidden_order_itemmeta', array($this,'custom_woocommerce_hidden_order_itemmeta'), 10, 1);
		add_action('woocommerce_checkout_create_order', array($this, 'add_custom_meta_data_to_order'), 20, 2);
        add_action('woocommerce_admin_order_totals_after_tax', array($this, 'custom_admin_order_totals_after_tax'), 10, 1 );
		add_action( 'template_redirect',array($this,  'after_stripe_redirect') );
	}

    function custom_admin_order_totals_after_tax( $order_id ) {
        $included_tax = get_post_meta( $order_id, 'cart_included_tax', true );
        if($included_tax) {
            $log = new My_WC_LogTracking();
            $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
        if($quivers_debug_mode){
            $log->debug_mode("custom_admin_order_totals_after_tax", "included_tax", $included_tax, WC()->customer->get_billing_email(),null, null);
        }
            echo '<tr><td class="label">' . 'Included Tax:' . '</td>' . '<td width="1%"></td>'. '<td class="total">'. $included_tax . '</td></tr>';
        }
    }

	function add_custom_meta_data_to_order( $order, $data ) {
	    $included_tax = WC()->session->get('cart_included_tax');
	    $included_tax = $included_tax ? $included_tax : null;
        $order->update_meta_data( 'cart_included_tax', $included_tax );
    }

	function custom_woocommerce_hidden_order_itemmeta($arr){
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$arr[] = '_item_tax_value';
        if($quivers_debug_mode){
            $log->debug_mode("custom_woocommerce_hidden_order_itemmeta", "item_tax_value", json_encode($arr), null,null, null);
        }
   		return $arr;
	}

	function ektgn_meta_to_line_item( $item, $cart_item_key, $values, $order )
	{
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
	    $_p = $item->get_product();
	    $key = '_item_tax_value';
	 	$val = isset($this->qqq['q_tax'][$values['product_id']][$values['variation_id']]) ? json_encode($this->qqq['q_tax'][$values['product_id']][$values['variation_id']]) : 0;
         if($quivers_debug_mode){
            $log->debug_mode("ektgn_meta_to_line_item", "item_tax_value", $key, WC()->customer->get_billing_email(),null, null);
        }
         if ( false !== ( $value = $_p->get_meta( $key, true ) ) )
	    {
	        $item->add_meta_data( $key , $val , true ); 
	    }
	                 
	}	

	function checkout_billing(){
	    $startTime = microtime(true);
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		// Call Validate API, if fails call Countries API and calculate taxes.
		$debuglog_cart_data = $this->model_data(WC()->cart);
		$log->debug_mode("checkout_billing", "cart_contents-1", json_encode($debuglog_cart_data), WC()->customer->get_billing_email(),null, null);
		if (is_checkout() || is_cart()) {
			//1.Model Data
			$data = $this->model_data(WC()->cart);
			$test = 'demo';
            $log->session_start(["Tax Data"=>$data], date('r', $startTime)."UTC");
			if (get_option('wc_settings_tab_demo_sandbox_status') == 'no') $test = '';
			$sitedata=[
				'client_type'=>'Woocommerce',
				'business_refid'=>get_option('wc_settings_tab_demo_business_refid')
			];
			$sitekeys = $this->CallAPI(
				"POST",
				"https://middleware.quivers".$test.".com/profile/retrieve/sitekeys",
				json_encode($sitedata),
				[array('Content-Type:application/json')]
			);
			$sitekeys =json_decode(json_encode($sitekeys), true);
			$_SESSION["site_keys"] = json_decode($sitekeys['data'],true);
            if($quivers_debug_mode){
                $log->debug_mode("checkout_billing", "sitekeys", json_encode($sitekeys), WC()->customer->get_billing_email(),null, null);
            }
			//2.CallAPI when shipping address
		   if (isset($data['items']) && sizeof($data['items']) > 0) {
				$res = $this->CallAPI(
					"POST",
					"https://api.quivers" . $test . ".com/v1/CustomerOrders/Validate",
					json_encode($data),
					[array('Content-Type:application/json')]
				);
				$request =  ["tax_url" => "https://api.quivers" . $test . ".com/v1/CustomerOrders/Validate", "tax_data" => $data];
				$res = json_decode($res['data'], true);
				$endTime = microtime(true);
                $order_detail = ["tax_data"=>$data, "Response"=>$res];
                
                $log->validate_api_call($request, $res, date('r', $startTime)."UTC", date('r', $endTime)."UTC");
                $log->session_end($order_detail, date('r', $endTime)."UTC");
			} else {

				$res['result']['items'] = [];
			}
			$_SESSION['ch_url'] = get_page_link() ;
			//3.UPDATE $cart_obj
			if (isset($res['result']['totals']['total'])) {
				$total_amount = $res['result']['totals']['total'];
				WC()->session->set('total_amount',$total_amount);
				$this->setTaxesFee($res['result']);
				$this->setStatementDescriptor($res['result']['statementDescriptor']);
				$this->setProperty($res['result']['payment']);

			}
			else {
				// if validate API failed, call countries API.
				$response = $this->CallAPI(
					"GET",
					"https://api.quivers" . $test . ".com/v1/Countries",
					false,
					false,
					5
				);
				$request =  ["tax_url" => "https://api.quivers" . $test . ".com/v1/Countries", "tax_data" => $data];
				$response_data = json_decode($response['data'], true);
				if (isset($response_data['result'])) {
					$this->setWorstTaxFee($response_data);
				}else {
					$amount =(WC()->cart->cart_contents_total+WC()->cart->get_shipping_total())-WC()->session->get('quivers_discount');
					WC()->session->set('total_amount',$amount);
				}
				$endTime = microtime(true);
				WC()->session->set('response',$response_data);
                $log->countries_api_call($request, $response, date('r', $startTime)."UTC", date('r', $endTime)."UTC");
                $log->session_end(["Tax Data"=>$data, "Response"=>$response["data"]], date('r', $endTime)."UTC");
			}
			
		}
	}

	function setProperty($payment) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$merchantId = '0';
        $destination = false;
        
        if(!empty($payment) && !empty($payment["destination"]))
        {
            $merchantId = $payment["accountId"];
            $destination = $payment["destination"];
        }
        WC()->session->set('destination',$destination);
        WC()->session->set('merchantId',$merchantId);
        if($quivers_debug_mode){
            $log->debug_mode("setProperty", "merchantId", $merchantId, WC()->customer->get_billing_email(),null, null);
        }
	}

	function setStatementDescriptor($statement_descriptor){
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
        // set statement descriptor as a session attribute
        $log = new My_WC_LogTracking();
		// truncating statement descriptor to 10 characters based on new Stripe requirements
		if(strlen($statement_descriptor) > 10){
			$size = strlen($statement_descriptor);
			$statement_descriptor = substr($statement_descriptor, 0, 10); 
            if($quivers_debug_mode){
                $log->debug_mode("setStatementDescriptor", "statement_descriptor", $statement_descriptor, WC()->customer->get_billing_email(),null, null);
            }
		}
		
        $log->statement_descriptor_log($statement_descriptor);
        WC()->session->set('statement_descriptor_suffix',$statement_descriptor);
    }


	function setTaxesFee($ci) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$email = WC()->customer->get_billing_email();
	    $startTime = microtime(true);
		$fees_add = 0;
		$q_tax = [];
		$fees_included = 0;
		if(isset($ci['items']) && sizeof($ci['items']) > 0){
			foreach ($ci['items'] as $prod) {
				foreach ($prod['pricing']['taxes'] as $k => $value) {
					$variationRefId = $prod['variantRefId'] == '' ? 0 : $prod['variantRefId'];
					$q_tax['q_tax'][$prod['productRefId']][$variationRefId] = isset($value['amount']) && $value['amount'] > 0 ? $value['amount'] : 0;
					if ($value['includedInSubtotal'] == false) {
					$fees_add += $value['amount'];
                    if($quivers_debug_mode){
                        $log->debug_mode("setTaxesFee", "fees_add", $fees_add, $email,null, null);
                    }
					}
					else{
					$fees_included += $value['amount'];
                    if($quivers_debug_mode){
                        $log->debug_mode("setTaxesFee", "fees_included-1", $fees_included, $email,null, null);
                    }
					}
				}
			}
			$log->wc_add_fee($ci,$fees_add,$fees_included,date('r', $startTime)."UTC");
			$this->qqq = $q_tax;
		
			if($fees_add && get_option('wc_settings_hide_tax_at_checkout_status') == 'no'){
				WC()->cart->add_fee( __('Estimated Tax', 'woocommerce'), $fees_add, false );
			}
		
		    if($fees_included){
                if($quivers_debug_mode){
                    $log->debug_mode("setTaxesFee", "fees_included-2", $fees_included, $email,null, null);
                }
                $fees_included = wc_price($fees_included);
                WC()->session->set('cart_included_tax', null);
                WC()->session->set( 'cart_included_tax', $fees_included );
		    } else WC()->session->set('cart_included_tax', null);
		} 
	}

	function setWorstTaxFee($countries_response_data) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$email = WC()->customer->get_billing_email();
		if (empty($countries_response_data)) {
            if($quivers_debug_mode){
                $log->debug_mode("setWorstTaxFee", "countries_response_data", $countries_response_data, $email,null, null);
            }
			return;
		}

		$cart = WC()->cart;
		$order_country_code = WC()->customer->get_shipping_country();
		$order_region_code = WC()->customer->get_shipping_state();
		$products = $cart->get_cart();
        
            $log->debug_mode("setWorstTaxFee", "products", $products, $email,null, null);
        
		// get worst tax rate.
		$country_max_tax_rate = NULL;
		foreach ($countries_response_data['result'] as $value) {
		  if ($value['abbreviations']['two'] === $order_country_code) {
		    foreach ($value['regions'] as $region_value) {
		      if (strcasecmp($region_value['abbreviation'], $order_region_code) == 0) {
		        $country_max_tax_rate = (float) $region_value['maxTaxRate'];
                if($quivers_debug_mode){
                    $log->debug_mode("setWorstTaxFee", "country_max_tax_rate-1", $country_max_tax_rate, $email, null, null);
                }
		        break;
		      }
		    }
		    // Quivers supports "N/A" regions for some countries.
		    if (!$country_max_tax_rate && array_key_exists('0', $value['regions'])) {
		      $country_max_tax_rate = (float) $value['regions']["0"]["maxTaxRate"];
              if($quivers_debug_mode){
                $log->debug_mode("setWorstTaxFee", "country_max_tax_rate-2", $country_max_tax_rate, $email, null, null);
                }
		    }
		  }
		  if ($country_max_tax_rate) {
            if($quivers_debug_mode){
				$log->debug_mode("setWorstTaxFee", "country_max_tax_rate-3", $country_max_tax_rate, $email, null, null);
			}
		    break;
		  }
		}
		if ($country_max_tax_rate === NULL) {
            if($quivers_debug_mode){
				$log->debug_mode("setWorstTaxFee", "country_max_tax_rate-4", $country_max_tax_rate, $email, null, null);
			}
			return;
		}

		// calculate and apply worst tax rate.
		$fees_add = 0;
		$totalAmount = 0;
		$subtotal = 0;
		$qqq_data = [];
		foreach($products as $product => $values){
			$item_id = $values['variation_id'] == 0 ? $values['product_id'] : $values['variation_id'];
			$product = wc_get_product( $item_id );
			if($product===false){
				$product = $values['data'];
                
					$log->debug_mode("setWorstTaxFee", "product", $product, $email, null, null);
				
			  }
			// $item_price = (float)$product->get_sale_price() ? (float)$product->get_sale_price() : (float)$product->get_price();
			try {

				$item_price = (float)$product->get_sale_price() ? (float)$product->get_sale_price() : (float)$product->get_price();
                if($quivers_debug_mode){
					$log->debug_mode("setWorstTaxFee", "item price-1", $item_price, $email, null, null);
				}
				
			} catch(Exception $e) {

				$item_price = (float)get_post_meta($item_id , '_sale_price', true) ? (float)get_post_meta($item_id , '_sale_price', true) : (float)get_post_meta($item_id , '_price', true);
				
                if($quivers_debug_mode){
					$log->debug_mode("setWorstTaxFee", "item price-2", $item_price, $email, null, null);
				}
            }
			$item_quantity = (int)$values['quantity'];
            if($quivers_debug_mode){
                $log->debug_mode("setWorstTaxFee", "item_quantity", $item_quantity, $email, null, null);
				}

			// creating q_tax data.
			$variationRefId = $values['variation_id'] == '' ? 0 : $values['variation_id'];
			$tax_amount = $item_price * $country_max_tax_rate * $item_quantity;
			$qqq_data['q_tax'][$values['product_id']][$variationRefId] = $tax_amount;
			$itemSubotal = $item_price * $item_quantity;
			$subtotal = $subtotal + $itemSubotal;
			$itemTotal = $itemSubotal + $tax_amount;
			// $taxableAmount = $itemSubotal - $itemDiscount;
			$totalAmount = $totalAmount + $itemTotal;
			

			// order total tax.
			$fees_add += $tax_amount;
            if($quivers_debug_mode){
                $log->debug_mode("setWorstTaxFee", "totalAmount-1", $totalAmount, $email,null, null);
            }
		}
		$totalAmount = $totalAmount + WC()->cart->get_shipping_total();
		WC()->session->set('total_amount',$totalAmount);
        if($quivers_debug_mode){
			$log->debug_mode("setWorstTaxFee", "totalAmount-2", $totalAmount, $email,null, null);
		}
		$this->qqq = $qqq_data;
		$cart->add_fee( __('Estimated Tax', 'woocommerce'), $fees_add, false );

	}

	function add_tab($settings_tabs){
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		add_option('quivers','');
		$settings_tabs['quivers_settings'] = __( 'Quivers', 'woocommerce-quivers_settings' );
		$settings_tabs['quivers_tax_settings'] = __( 'Quivers Tax', 'woocommerce-quivers_tax_settings' );
		do_action('quivers_add_tab');
       
		return $settings_tabs;
	}

	function load_form() {
		woocommerce_admin_fields( $this->get_settings() );
	}

	function load_quivers_tax_form() {
		woocommerce_admin_fields( $this->get_quivers_tax_settings() );
	}

	function get_settings() {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		if($_GET["tab"]=='quivers_settings') {
			if(get_option('quivers')==='Inactive') {
				$class="danger";
				$connection =get_option('quivers'); 
                if($quivers_debug_mode){
                    $log->debug_mode("get_settings", "connection", $connection, null,null, null);
                }
			} 
			if(get_option('quivers')==='Active'){
				$class="success";
				$connection = get_option('quivers'); 
                if($quivers_debug_mode){
                    $log->debug_mode("get_settings", "connection", $connection, null,null, null);
                }
			}		
			?>
			<script>
				setTimeout(function(){ 
					jQuery('body').find('.connection').remove();
					jQuery('body').find("table").before('<div class="connection"><span class="badge badge-<?php echo $class; ?>"><?php echo $connection; ?></span></div>'); 
					if(jQuery('body').find('.connection').length>1){
						jQuery('body').find('.connection').first().remove();
					}
				 }, 1000);
			</script>
			<?php
		}

		$settings = array(
	        'quivers_settings' => array(
	            'name'     => __( 'Quivers Integration Settings', 'woocommerce-quivers_settings' ),
	            'type'     => 'title',
				'desc'     => '',
				'class'    => 'quivers_setting_feilds',
	            'id'       => 'wc_settings_tab_demo_section_title'
	        ),
	        'apikey' => array(
	            'name' => __( 'Quivers API key:', 'woocommerce-quivers_settings' ),
	            'type' => 'text',
				'id'   => 'wc_settings_tab_demo_apikey',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => 'Enter the Quivers API key shared by your Quivers Project Manager. This key will be used by the integration to access Quivers APIs for your business account.'
	        ),
	        'business_refid' => array(
	            'name' => __( 'Business RefId:', 'woocommerce-quivers_settings' ),
	            'type' => 'text',
				'id'   => 'wc_settings_tab_demo_business_refid',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => 'Enter the Business Ref Id shared by your Quivers Project Manager. This is a unique id that represents your business account on Quivers Admin Panel. The integration will use this to be able to access your orders to update statuses and tracking information.'
	        ),
	        'wp_base_url' => array(
	            'name' => __( 'WP Integration Base URL:', 'woocommerce-quivers_settings' ),
	            'type' => 'text',
				'id'   => 'wc_settings_tab_demo_wp_base_url',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => 'Enter the base URL of your site. Please ensure that if test mode is disabled , please set the base URL to HTTPS. The integration will use this base URL to hit Woocommerce APIs to get orders placed by the customers. '
	        ),
			'wp_username' => array(
	            'name' => __( 'WP Integration Username:', 'woocommerce-quivers_settings' ),
	            'type' => 'text',
				'id'   => 'wc_settings_tab_demo_wp_username',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => 'Enter the consumer key generated while setting up the Rest API user for Quivers integration. Refer to "Configure REST API in Woocommerce " section from the plugin installation document for further information.'
	        ),
	        'wp_auth_token' => array(
	            'name' => __( 'WP Integration Auth Token:', 'woocommerce-quivers_settings' ),
				'type' => 'text',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => 'Enter the consumer secret generated while setting up the Rest API user for Quivers integration. Refer to "Configure REST API in Woocommerce" section from the plugin installation document for further information.',
				'id'   => 'wc_settings_tab_demo_wp_auth_token',
			 ),
	        'sandbox_status' => array(
	            'name' => __( 'Quivers Sandbox Enabled:', 'woocommerce-quivers_settings' ),
				'type' => 'select',
				'class'    => 'quivers_setting_feilds',
				'id'   => 'wc_settings_tab_demo_sandbox_status',
				'desc_tip'	   => 'Set quivers Sandbox Enabled to "Yes" if you are using the extension in your test environment . When in live mode, set it to "No".',
	            'options'       => array(
			    	'yes'		=> __( 'Yes', 'wps' ),
			        'no'	=> __( 'No', 'wps' )
			    )
	        ),
	        'quivers_debug' => array(
	            'name' => __( 'Quivers Debug Mode:', 'woocommerce-quivers_settings' ),
				'type' => 'select',
				'class'    => 'quivers_setting_feilds',
				'id'   => 'wc_settings_tab_debug_key',
				'desc_tip'	   => 'Set quivers Debug Mode to "Yes" to enable the plugin logs.',
	            'options'       => array(
			    	1		=> __( 'ON', 'wps' ),
			        0	=> __( 'OFF', 'wps' )
			    )
	        ),
			'restock_refund_status' => array(
					'name' => __( 'Restock Refunded Items:', 'woocommerce-quivers_settings' ),
					'type' => 'select',
					'class'    => 'quivers_setting_feilds',
					'id'   => 'wc_settings_tab_demo_restock_refund_status',
					'desc_tip'	   => 'If set to yes, everytime an order item is refunded on Quivers, the integration will restock the items when relaying the refund back to Woocommerce.',
					'options'       => array(
					'true'		=> __( 'Yes', 'wps' ),
					'false'	=> __( 'No', 'wps' )
							    )
					        ),
	       	'quivers_preorder_key' => array(
	            'name' => __( 'Pre-order Key:', 'woocommerce-quivers_settings' ),
				'type' => 'text',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => "Since Preorder isn't a standard field in Woocommerce, you can use “Pre-order Key” ‘to provide the custom field that you have created on the product page to refer to when syncing Preorder. Please note that you should provide the field name from the API that represents your Preorder field on the UI",
				'id'   => 'wc_settings_tab_demo_quivers_preorder_key',
			 ),
	       	'quivers_upc_field' => array(
	            'name' => __( 'UPC Field:', 'woocommerce-quivers_settings' ),
				'type' => 'text',
				'class'    => 'quivers_setting_feilds',
				'desc_tip'	   => "Since UPC isn't a standard field in Woocommerce, you can use “UPC Field” ‘to provide the custom field that you have created on the product page to refer to when syncing UPCs. Please note that you should provide the field name from the API that represents your UPC field on the UI",
				'id'   => 'wc_settings_tab_demo_quivers_upc_field',
			 ),
	        'section_end' => array(
	             'type' => 'sectionend',
	             'id' => 'wc_settings_tab_demo_section_end'
	        )
	    );
		return apply_filters( 'wc_settings_tab_demo_settings', $settings );
	}

	function get_quivers_tax_settings() {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$quivers_marketplaces = get_option('wc_quivers_marketplaces');
		$quivers_claimings = get_option('wc_quivers_claiminggroups');
        if($quivers_debug_mode){
            $log->debug_mode("get_quivers_tax_settings", "quivers_debug_mode", $quivers_debug_mode, null, null, null);
        }

		$tax_settings = array(
	        'quivers_tax_settings' => array(
	            'name' => __( 'Quivers Tax Settings', 'woocommerce-quivers_tax_settings' ),
	            'type' => 'title',
	            'desc' => '',
	            'id'   => 'wc_settings_tab_tax_section_title'
			),

	        'usd' => array('name' => __( 'USD Marketplace:', 'woocommerce-quivers_tax_settings' ),
				'type' => 'select',
				'id'   => 'wc_settings_tab_tax_quivers_marketplace_usd',
				'class'=> 'quivers_tax_settings_feild',
				'options' => $quivers_marketplaces
			),
			'usd_cl' => array(
				'name'    => __( 'Claiming Group:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'multiselect',
				'id'      => 'wc_settings_tab_tax_quivers_claiming_group_usd',
				'class'=> 'quivers_tax_settings_claimingfeild ',
				'custom_attributes' =>'multiple',
				'options' => $quivers_claimings
			),
	        'eur' => array(
				'name'    => __( 'EUR Marketplace:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'select',
				'id'      => 'wc_settings_tab_tax_quivers_marketplace_eur',
				'class'   => 'quivers_tax_settings_feild',
				'options' => $quivers_marketplaces
			),
			'eur_cl' => array(
				'name'    => __( 'Claiming Group:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'multiselect',
				'id'      => 'wc_settings_tab_tax_quivers_claiming_group_eur',
				'class'   => 'quivers_tax_settings_claimingfeild',
				'options' => $quivers_claimings
			),
			'aud' => array(
				'name'    => __( 'AUD Marketplace:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'select',
				'id'      => 'wc_settings_tab_tax_quivers_marketplace_aud',
				'class'   => 'quivers_tax_settings_feild',
				'options' => $quivers_marketplaces
			),
			'aud_cl' => array(
				'name'    => __( 'Claiming Group:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'multiselect',
				'id'      => 'wc_settings_tab_tax_quivers_claiming_group_aud',
				'class'   => 'quivers_tax_settings_claimingfeild',
				'options' => $quivers_claimings
			),
			'jpy' => array(
				'name'    => __( 'JPY Marketplace:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'select',
				'id'      => 'wc_settings_tab_tax_quivers_marketplace_jpy',
				'class'   => 'quivers_tax_settings_feild',
				'options' => $quivers_marketplaces
			),
			'jpy_cl' => array(
				'name'    => __( 'Claiming Group:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'multiselect',
				'id'      => 'wc_settings_tab_tax_quivers_claiming_group_jpy',
				'class'   => 'quivers_tax_settings_claimingfeild',
				'options' => $quivers_claimings
			),
			'gbp' => array(
				'name'    => __( 'GBP Marketplace:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'select',
				'id'      => 'wc_settings_tab_tax_quivers_marketplace_gbp',
				'class'   => 'quivers_tax_settings_feild',
				'options' => $quivers_marketplaces
			),
			'gbp_cl' => array(
				'name'    => __( 'Claiming Group:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'multiselect',
				'id'      => 'wc_settings_tab_tax_quivers_claiming_group_gbp',
				'class'   => 'quivers_tax_settings_claimingfeild',
				'options' => $quivers_claimings
			),
	        'cad' => array(
				'name'    => __( 'CAD Marketplace:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'select',
				'id'      => 'wc_settings_tab_tax_quivers_marketplace_cad',
				'class'   => 'quivers_tax_settings_feild',
				'options' => $quivers_marketplaces
			),
			'cad_cl' => array(
				'name'    => __( 'Claiming Group:', 'woocommerce-quivers_tax_settings' ),
				'type'    => 'multiselect',
				'id'      => 'wc_settings_tab_tax_quivers_claiming_group_cad',
				'class'   => 'quivers_tax_settings_claimingfeild',
				'options' => $quivers_claimings
			),
	        'hide_tax_at_checkout' => array(
	            'name' => __( 'Hide Tax at Checkout:', 'woocommerce-quivers_tax_settings' ),
	            'type' => 'select',
				'id'   => 'wc_settings_hide_tax_at_checkout_status',
				'desc_tip'	   => 'If set to "yes", the customers will not see the tax calculated on checkout. But the amount authorised will include the tax.',
	            'options'       => array(
			    	'yes'		=> __( 'Yes', 'wps' ),
			        'no'	=> __( 'No', 'wps' )
			    )
			),
	        'section_end' => array(
				'type' => 'sectionend',
				'id'   => 'wc_settings_tab_tax_section_end'
	        )
	    );
		
		return apply_filters( 'wc_settings_tab_tax_settings', $tax_settings );
	}

	function profileCreate($result){
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$request_data = [
	      "client_type" => "Woocommerce",
	      "base_url" => $result['wp_base_url'],
	      "business_refid" => $result['business_refid'],
	      "api_key" => $result['apikey'],
	      "consumer_key" => $result['wp_username'],
		  "consumer_secret" => $result['wp_auth_token'],
		  "sandbox_status" =>$result['sandbox_status'],
		  "restock_refund_status" => $result['restock_refund_status'],
		  "client_upc_key" =>$result['client_upc_key'],
		  "client_preorder_key" =>$result['client_preorder_key'],
		  "enable_plugin" => "true"
		];
        if($quivers_debug_mode){
            $log->debug_mode("profileCreate", "request_data", $request_data, null,null, null);
        }
		$result = $this->validateSettings($request_data); 

		if($result===true) {
			$test = 'demo';
			if(get_option('wc_settings_tab_demo_sandbox_status') == 'no') $test = '';
	
			$response = $this->CallAPI(
				"POST",
				"https://middleware.quivers" . $test . ".com/profile/create",
				json_encode($request_data),
				[array('Content-Type:application/json')]
			);
			$tab = 'quivers_tax_settings';
			$this->responseAction($response,$tab);
			
			if($response['httpcode'] == 200){
				return json_decode($response['data'], true)['uuid'];
                if($quivers_debug_mode){
                    $log->debug_mode("profileCreate", "Profile create Response and Request", null, null,$request, json_encode($response));
                }
			}
		}	
	}
	function validateSettings($data) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$checksandbox = 'no';
		if(! preg_match('/^http(s)?:\/\/[a-z0-9-]+(\.[a-z0-9-]+)*(:[0-9]+)?(\/.*)?$/i', $data['base_url']) ){
			$key = 'url';
			$message = "Invalid Url.Please try again with valid url. If the issue still persists,please contact 'enterprise@quivers.com' for further assistance.";
			$this->printErrorMsg($message,$key);
			return false;
		} else if(($data['sandbox_status']==$checksandbox) && preg_match("#((https)://(\S*?\.\S*?))(\s|\;|\)|\]|\[|\{|\}|,|”|\"|'|:|\<|$|\.\s)#", $data['base_url'])!=1){
			$key = 'url';
			$message = "Invalid Url, if test mode is disabled, please set the base URL to https and try again. If the issue still persists,please contact 'enterprise@quivers.com' for further assistance.";
			$this->printErrorMsg($message,$key);
			return false;
		} else {
			global $wpdb;
			$dbResult =$wpdb->get_results( 'SELECT * FROM ' . $wpdb->prefix . 'woocommerce_api_keys' );
			$dataArray = [];
			foreach ($dbResult as $dbResultvalues) {
				$resultarr = json_decode(json_encode($dbResultvalues), true);
				array_push($dataArray,$resultarr['truncated_key']);
				array_push($dataArray,$resultarr['consumer_secret']);		
			}

			if ($data['sandbox_status']==$checksandbox)
			{
				$newstring = substr($data['consumer_key'], -7);
				if (in_array($newstring,$dataArray)==true)
				{
					if (in_array($data['consumer_secret'],$dataArray)===false)
						{
							$key = 'token';
							$message = "Invalid consumer secret key. Please try again with valid consumer secret key. If the issue still persists,please contact 'enterprise@quivers.com' for further assistance.";
							$this->printErrorMsg($message,$key);
						} else {
							update_option('quivers','Active');
							return true;
						}
				} else {
					$key = 'username';
					$message = "Invalid consumer key. Please try again with valid consumer key. If the issue still persists,please contact 'enterprise@quivers.com' for further assistance.";
					$this->printErrorMsg($message,$key);
				}
			}else {
				return true;
			}
		}

	}
	
	function printErrorMsg($message,$key) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$ids = [
			'api' => 'wc_settings_tab_demo_apikey',
			'ref_id' =>'wc_settings_tab_demo_business_refid',
			'url' =>'wc_settings_tab_demo_wp_base_url',
			'username'  =>'wc_settings_tab_demo_wp_username',
			'authorization' =>['wc_settings_tab_demo_wp_username','wc_settings_tab_demo_wp_auth_token'],
			'token' =>'wc_settings_tab_demo_wp_auth_token'
		  ];
          if($quivers_debug_mode){
            $log->debug_mode("printErrorMsg", "ids", $ids, null,null, null);
        }
		?>
		<script>  
			setTimeout(function(){ 
				<?php  if(is_array($key)) {
						foreach($key as $value) {
						?>
						jQuery("#<?php echo $ids[$value]; ?>").css("border-color", "red");
				<?php  
						}
					} else {
						if($key!=null) {
						?>
						jQuery("#<?php echo $ids[$key]; ?>").css("border-color", "red");
				<?php } } ?>
			
			
					jQuery('body').find("form").find('nav').after("<div class='Quivers_error error notice'><p><strong><?php echo $message; ?></strong></p></div>");
				}, 1500);
		</script>
		<?php
		update_option('quivers','Inactive');
	}

	function responseAction($response,$tab) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		if($response['httpcode'] != 200){
			update_option('quivers','Inactive');
			if($response['httpcode']==500 || $response['httpcode']==502) {
				$message = "Internal server error";
				$key = Null;
                if($quivers_debug_mode){
                    $log->debug_mode("responseAction", "message-1", $message, null,null, null);
                }
			} else {
				$message = isset(json_decode($response['data'], true)['error']['message'])?json_decode($response['data'], true)['error']['message']:json_decode($response['data'], true)['error'];
				$key =isset(json_decode($response['data'], true)['error']['key'])?json_decode($response['data'], true)['error']['key']:Null;
                if($quivers_debug_mode){
                    $log->debug_mode("responseAction", "message-2", $message, null,null, null);
                }
            }
			$this->printErrorMsg($message,$key);
            if($quivers_debug_mode){
                $log->debug_mode("responseAction",$key, $message, null,null, null);
            }
			return NULL;
		} else {
			$res_data = json_decode($response['data'], true);
			if(isset($res_data['isactive']) && $res_data['isactive']=='false') {
				update_option('quivers','Inactive');
				$message = "Failed to conect to Quivers. Please check if the settings in Quivers and Quivers tax Tabs are saved correctly. If the issue still persists,please contact 'enterprise@quivers.com' for further assistance.";
				$this->printErrorMsg($message,Null);
                if($quivers_debug_mode){
                    $log->debug_mode("responseAction", "message-3", $message, null,null, null);
                }
				return NULL;
			} else{
				update_option('quivers','Active');
			}
			$url = site_url()."/wp-admin/admin.php?page=wc-settings&tab=".$tab;
			echo("<script>location.href = '".$url."';</script>");
		}
	}

	function profileUpdate() {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$currencies = ["usd", "eur", "aud", "jpy", "gbp", "cad"];
		$marketplaces_request_data = [];
		foreach ($currencies as $currency) {
			if (!get_option('wc_settings_tab_tax_quivers_marketplace_' . $currency)) {
				continue;
			}
			$data = [];
			$data['currency'] = $currency;
			$data['marketplace_id'] = get_option('wc_settings_tab_tax_quivers_marketplace_' . $currency);
			$data['claiming_group_ids'] = get_option('wc_settings_tab_tax_quivers_claiming_group_' . $currency);
			if($quivers_debug_mode){
				$log->debug_mode("profileUpdate", "marketplaces_request_data-1", json_encode($data), null,null, null);
			}
			array_push($marketplaces_request_data, $data);
		}
	
			
		$request_data = [
			"marketplaces" => $marketplaces_request_data,
		];
		if($quivers_debug_mode){
		$log->debug_mode("profileUpdate", "marketplaces_request_data-2", json_encode($request_data), null,null, null);
	}
		$headers = [
			array('Content-Type:application/json'),
			array('uuid:' . get_option('wc_middleware_profile_id')),
		];

		$test = 'demo';
		if (get_option('wc_settings_tab_demo_sandbox_status') == 'no') $test = '';

		
		$response = $this->CallAPI(
				"POST",
				"https://middleware.quivers" . $test . ".com/profile/update/marketplaces",
				json_encode($request_data),
				$headers
			);

		$tab = 'quivers_settings';
		if($quivers_debug_mode){
		$log->debug_mode("profileUpdate", "marketplaces_request_data-3", null, null,json_encode($request_data), $this->responseAction($response,$tab));
	}
		return $this->responseAction($response,$tab);

	}


	function update_settings() {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');

		woocommerce_update_options( $this->get_settings() );

// 		$this->update_products();

		$result['apikey'] = get_option('wc_settings_tab_demo_apikey');
		$result['business_refid'] = get_option('wc_settings_tab_demo_business_refid');
		$result['wp_auth_token'] = get_option('wc_settings_tab_demo_wp_auth_token');
		$result['wp_username'] = get_option('wc_settings_tab_demo_wp_username');
		$result['wp_base_url'] = get_option('wc_settings_tab_demo_wp_base_url');
		$result['sandbox_status'] = get_option('wc_settings_tab_demo_sandbox_status');
		$result['client_upc_key'] = get_option('wc_settings_tab_demo_quivers_upc_field');
		$result['client_preorder_key'] = get_option('wc_settings_tab_demo_quivers_preorder_key');
		$result['restock_refund_status'] = get_option('wc_settings_tab_demo_restock_refund_status');

		
		// save Quivers Marketplaces in db
		$data = $this->getQuiversMarketplaces($result);

		if ( !$data['quivers_marketplaces'] ) {
			return;
		}

		$this->getOrCreateOption('wc_quivers_marketplaces', $data['quivers_marketplaces']);
		$this->getOrCreateOption('wc_quivers_claiminggroups', $data['quivers_claimings']);
		$middleware_profile_id = $this->profileCreate($result);
		$this->getOrCreateOption('wc_middleware_profile_id', $middleware_profile_id);
		if($quivers_debug_mode){
            $log->debug_mode("update_settings", "request_data", json_encode($request_data), null,null, null);
        }

	}




	function update_tax_settings($result) {
		woocommerce_update_options( $this->get_quivers_tax_settings() );
		$this->profileUpdate();

	}

	function getQuiversMarketplaces($result) {
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$data = [
			'quivers_marketplaces'=>[
				'' => '- Select a Marketplace -'
			],
			'quivers_claimings'=>[
				'' => '- Select Claiming groups -'
			],
		];
		if ( $result['sandbox_status'] == 'no' ) {
			$claim_url = "https://cloudhub-internal.quivers.com/api/v1/private/ClaimingPolicies/GetByBusiness?refId=" . $result['business_refid'];
			$url = "https://cloudhub-internal.quivers.com/api/v1/private/ProductGroups/MyProductGroups?refId=" . $result['business_refid'];
			if($quivers_debug_mode){
				$log->debug_mode("getQuiversMarketplaces", "sandbox_status-No", json_encode($data), null,null, null);
			}
		}
		else {
			$url = "https://cloudhub.quiversdemo.com/api/v1/private/ProductGroups/MyProductGroups?refId=" . $result['business_refid'];
			$claim_url = "https://cloudhub.quiversdemo.com/api/v1/private/ClaimingPolicies/GetByBusiness?refId=" . $result['business_refid'];
		}
		$response = $this->CallAPI(
			"GET",
			$url,
			false,
			[array('Authorization: apikey ' . $result['apikey'])]
		);
		$claim_response = $this->CallAPI(
			"GET",
			$claim_url,
			false,
			[array('Authorization: apikey ' . $result['apikey'])]
		);

		if ( $response['httpcode'] != 200 or $claim_response['httpcode']!=200) {
			return $data;
		}

		$product_groups = json_decode($response['data'], true);
		$claim_product_groups = json_decode($claim_response['data'], true);

		foreach ($product_groups as $product_group) {
		  if ($product_group['Type'] === 'Marketplace') {
			$data['quivers_marketplaces'] = array_merge($data['quivers_marketplaces'], [$product_group['Id'] => $product_group['Name']]);

		  }
		}
		foreach ($claim_product_groups as $claim_product_group) {
			if($claim_product_group['Inclusive']){
				$data['quivers_claimings'] = ($data['quivers_claimings']+[(string)$claim_product_group['Id'] => $claim_product_group['Name']]);
			}
			
		}
		return $data;
		if($quivers_debug_mode){
			$log->debug_mode("getQuiversMarketplaces", "quivers_claimings", json_encode($data['quivers_claimings']), null,null, null);
		}if($quivers_debug_mode){
			$log->debug_mode("getQuiversMarketplaces", "quivers_marketplaces", json_encode($data['quivers_marketplaces']), null,null, null);
		}
	}

	function model_data( $input ){
        $log = new My_WC_LogTracking();
        $quivers_debug_mode = get_option('wc_settings_tab_debug_key');
		$email =  WC()->customer->get_billing_email();
		$data = [];
		$Qdiscount =0;
		set_error_handler(array($this,'exceptions_error_handler'));
		try{
			$marketplace_id = get_option('wc_settings_tab_tax_quivers_marketplace_' . get_woocommerce_currency());
			if($quivers_debug_mode){
				$log->debug_mode("model_data", "marketplace_id", $marketplace_id, null,null, null);
			}
			if (!$marketplace_id) {
				if($quivers_debug_mode){
					$log->debug_mode("model_data", "marketplace_id", $marketplace_id, null,null, null);
				}
				return $data;
			}
			$claiminggroup_id = get_option('wc_settings_tab_tax_quivers_claiming_group_' . get_woocommerce_currency());
			$data['marketplaceId'] = $marketplace_id;
			$data['claimingId'] = $claiminggroup_id ;
			$data['customer']['firstname'] = WC()->customer->get_shipping_first_name();
			$data['customer']['lastname'] = WC()->customer->get_shipping_last_name();
			$data['customer']['email'] = WC()->customer->get_billing_email();
			$data['shippingAddress']['firstname'] = WC()->customer->get_shipping_first_name();
			$data['shippingAddress']['lastname'] = WC()->customer->get_shipping_last_name();
			$data['shippingAddress']['email'] = WC()->customer->get_billing_email();
			$data['shippingAddress']['company'] = WC()->customer->get_shipping_company();
			$data['shippingAddress']['phoneNumber'] = WC()->customer->get_billing_phone();
			$data['shippingAddress']['line1'] = WC()->customer->get_shipping_address_1();
			$data['shippingAddress']['line2'] = WC()->customer->get_shipping_address_2();
			$data['shippingAddress']['city'] = WC()->customer->get_shipping_city();
			$data['shippingAddress']['postCode'] = WC()->customer->get_shipping_postcode();
			$data['shippingAddress']['country'] = WC()->customer->get_shipping_country();
			$data['shippingAddress']['region'] = WC()->customer->get_shipping_state();

			if (!$data['shippingAddress']['region'])
			{
			$data['shippingAddress']['region'] = 'N/A';
			}

			$prods = $input->get_cart();
			$amount = strip_tags(WC()->cart->get_shipping_total());
			//$shipping_amt_total = (float)substr($amount, 5, strlen($amount));
			$shipping_amt_total = $amount;
			$shipping_amt_per_item = (float) $shipping_amt_total/sizeof($prods);
			$shipping_amt_per_item = floatval(substr($shipping_amt_per_item, 0, strpos($shipping_amt_per_item, '.') + 3));
			$shipping_amt_diff = round($shipping_amt_total - ($shipping_amt_per_item * sizeof($prods)), 2);
			if($quivers_debug_mode){
				$log->debug_mode("model_data", "shipping_amt_per_item", $shipping_amt_per_item, $email,null, null);
			}
			foreach($prods as $prod => $values){

				$_product =  wc_get_product( $values['data']->get_id() );
				if($_product===false){
					$_product = $values['data'];
					
						$log->debug_mode("model_data", "product", json_encode($_product), $email,null, null);
	
				  }
				$tax_code = $_product->get_meta('custom_product_tax_code');
				if($quivers_debug_mode){
					$log->debug_mode("model_data", "tax_code", json_encode($tax_code), $email,null, null);
				}
				$prod_var_opt = array();
				if(sizeof($values['variation']) > 0){
					$i=0;
					foreach ($values['variation'] as $key => $value) {
						$prod_var_opt[$i]["name"] = $key;
						$prod_var_opt[$i]["value"]["name"] = $value;
						$i++;
					}
				}

				$shipping_fees = array();

				$shipping_fees["name"] = "FedEx 2-Day";
				$shipping_fees["amount"] = $shipping_amt_per_item;

				$items = array();
				$items["product"]["name"] = $_product->get_title();
				$items["product"]["refId"] = $values['product_id'];
				$items["product"]["variant"]["name"] = $_product->get_name();
				$items["product"]["variant"]["refId"] = $values['variation_id'];
				$items["product"]["variant"]["option"][] = $prod_var_opt;
				$items["quantity"] = (float)$values['quantity'];
				$type_id = $values['variation_id'] == 0 ? $values['product_id'] : $values['variation_id'];
				$product_id = wc_get_product( $type_id);
				if($quivers_debug_mode){
					$log->debug_mode("model_data", "product_id-1", $product_id, $email,null, null);
				}
				
					$log->debug_mode("model_data", "items", json_encode($items), $email,null, null);
				
				if($product_id===false){
					$product_id = $values['data'];
					if($quivers_debug_mode){
						$log->debug_mode("model_data", "product_id-2", $product_id, $email,null, null);
					}
				  }
				try{
					$items["pricing"]["unitPrice"] = (float)  round($product_id->get_price(),2);
					$sale_price  = $product_id->get_sale_price()!=0 ?$product_id->get_sale_price():$product_id->get_price();
					$items["pricing"]["salePrice"] = (float)  round($sale_price ,2);
					if($quivers_debug_mode){
						$log->debug_mode("model_data", "items[pricing][salePrice]-1", json_encode($items["pricing"]["salePrice"]), $email,null, null);
					}
					if($quivers_debug_mode){
						$log->debug_mode("model_data", "items[pricing][unitPrice]-1", json_encode($items["pricing"]["unitPrice"]), $email,null, null);
					}

				} catch(Exception $e) {
					$items["pricing"]["unitPrice"] = (float) round(get_post_meta($type_id , '_price',true),2);
					$items["pricing"]["salePrice"] = (float)get_post_meta($item_id , '_sale_price', true) ? (float)get_post_meta($item_id , '_sale_price', true) : (float)get_post_meta($item_id , '_price', true);
					if($quivers_debug_mode){
						$log->debug_mode("model_data", "items[pricing][salePrice]-2", json_encode($items["pricing"]["salePrice"]), $email,null, null);
					}
					if($quivers_debug_mode){
						$log->debug_mode("model_data", "items[pricing][unitPrice]-2", json_encode($items["pricing"]["unitPrice"]), $email,null, null);
					}
				}
				$items["pricing"]["shippingFees"][] = $shipping_fees;
				$items["pricing"]["customFees"] = [];
				if($quivers_debug_mode){
					$log->debug_mode("model_data", "items[pricing][shippingFees][]", $shipping_fees, $email,null, null);
				}
				if ($tax_code) $items["product"]["taxCode"] = $tax_code;
				
					$log->debug_mode("model_data", "cart_contents", json_encode(WC()->cart->cart_contents), $email,null, null);
				
				if ( sizeof(WC()->cart->get_applied_coupons()) > 0 ) {
					foreach (WC()->cart->cart_contents as $key => $item_data) {
						if ($item_data['product_id'] != $values['product_id']) {
							continue;
						}
						if($item_data['variation_id'] == $values['variation_id']){
						$pricing_disc = [];
						$pricing_disc[0]["name"] = 'Discount';
						$pricing_disc[0]["amount"] = -($item_data['line_subtotal'] - $item_data['line_total']);
						$items["pricing"]["discounts"] = $pricing_disc;
						$Qdiscount += ($item_data['line_subtotal'] - $item_data['line_total']);
					}
				}
			}
			   WC()->session->set('quivers_discount',$Qdiscount);
				$data["items"][] = $items;
			}

			foreach ($data["items"] as &$payload_item) {
				if (!$shipping_amt_diff) {
					break;
				}

				$payload_item["pricing"]["shippingFees"][0]["amount"] += 0.01;
				$shipping_amt_diff -= 0.01;
			}
			unset($payload_item);

		} catch(Exception $e){
			restore_error_handler();
		}
		restore_error_handler();

		return $data;
	}
	////////////////////////////////////////////////////////////////////////////
	/////////////////////////Important Functions////////////////////////////////
	////////////////////////////////////////////////////////////////////////////
	function CallAPI($method, $url, $data = false, $headers = false, $timeout = 10)
	{
  		$curl = curl_init();

		switch ($method)
		{
			case "POST":
				curl_setopt($curl, CURLOPT_POST, 1);
				// curl_setopt( $curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
				if ($data)
					curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
				break;
			case "PUT":
				curl_setopt($curl, CURLOPT_PUT, 1);
				break;
			default:
				if ($data)
					$url = sprintf("%s?%s", $url, http_build_query($data));
		}

		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, $timeout - 1);
		curl_setopt($curl, CURLOPT_TIMEOUT, $timeout);
		if ($headers) {
			foreach ($headers as $header) {
				curl_setopt( $curl, CURLOPT_HTTPHEADER, $header);
			}
		}

		$res = [];
		try{
			$result = curl_exec($curl);
		}
		catch(Exception $e) {
			return $res;
		}

		$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		$res['data'] = $result;
		$res['httpcode'] = @$httpcode;
		return $res;
	}

	function getOrCreateOption($option, $option_value) {
       if (get_option($option)) {
			update_option($option, $option_value);
	    }
	    else {
			$is_added = add_option($option, $option_value, '', 'yes');
			if (!$is_added) {
				// returns false if an option with the same name exists
				// try deleting and adding again
				delete_option($option);
				add_option($option, $option_value, '', 'yes');
			}
	    }
	}

	function add_menu_items() {
		add_menu_page('Settings','Quivers','manage_options','quivers_taxes',array($this,'load_form'));
	}

	function exceptions_error_handler($severity, $message, $filename, $lineno) {
		if ($severity) {
			throw new ErrorException($message, 0, $severity, $filename, $lineno);
		}
	}

	function so_31413975_extra_checkout_fields(){ 

  		// $this->setIntent(WC()->session->get('total_amount'));
		if(WC()->session->get('stripe_enable') && WC()->session->get('stripe_enable')==='yes') {
		  $checkout = WC()->checkout(); 
	
		?>
		<input type="hidden" id="ip_address" value="<?php echo $_SERVER["REMOTE_ADDR"]; ?>"/>
		<div class="g-recaptcha" id="quivers_captcha" data-sitekey="<?php  echo isset($_SESSION['site_keys']['site_key'])?$_SESSION['site_keys']['site_key']:'SITE_KEY_NOT_THERE'?>" data-badge="inline" data-size="invisible" data-callback="setResponse"></div>
			<?php 
		}
		  
	   }
	   
	   function after_stripe_redirect(){
		$log = new My_WC_LogTracking();
		   /* we need only thank you page */
		   
		 
		   if(isset($_GET['order'])){
		   if ( get_page_link() ===  wc_get_checkout_url()) {
				if(WC()->session->get('intent_id') && WC()->session->get('intent_id')!=null && WC()->session->get('order_complete_url')){
					\Stripe\Stripe::setApiKey(WC()->session->get('private_key'));
					$intent = \Stripe\PaymentIntent::retrieve(WC()->session->get('intent_id'));
					$order_id = $_GET['order'];
					$order = wc_get_order( $order_id );
						if ($intent->status == "requires_capture")
						{
							
							$order->payment_complete($intent->charges->data[0]->id);
							wc_reduce_stock_levels($order_id);
							WC()->session->set('intent_id',null);
							$log->payment_complete(json_encode($intent));
							wp_redirect(WC()->session->get('order_complete_url'));
							exit;
						}else{
							wc_add_notice('Failed to prepare the payment flow. Please try again. If the issue persists please contact Quivers at 805-250-4555', 'error' );
						
						}
							
				}
		   }
		}
			   
	   
	   }
	/*--------------------------------ENDS---------------------------------*/					

}//Class Ends

// finally instantiate our plugin class and add it to the set of globals
if( class_exists("My_WC_Cart") ) $GLOBALS['my_wc_cart'] = new My_WC_Cart();

?>