<?php

function create_product_tax_code_field() {
	$args = array(
		'id'            => 'custom_product_tax_code',
		'label'         => __( 'Product Tax Code', 'cfwc' ),
		'class'					=> 'cfwc-custom-field',
		'desc_tip'      => true,
		'description'   => __( 'Enter the tax code of your Product.', 'ctwc' ),
	);
	woocommerce_wp_text_input( $args );
}
add_action( 'woocommerce_product_options_inventory_product_data', 'create_product_tax_code_field' );

function save_product_tax_code( $post_id ) {
	$product = wc_get_product( $post_id );
	$title = isset( $_POST['custom_product_tax_code'] ) ? $_POST['custom_product_tax_code'] : '';
	$product->update_meta_data( 'custom_product_tax_code', sanitize_text_field( $title ) );
	$product->save();
}
add_action( 'woocommerce_process_product_meta', 'save_product_tax_code' );