<?php include_once("css/custom_buttons_style.php"); ?>

<a href="#" class="button edit-invoice" id="cus_invoice">Invoice</a>
<a href="#" class="button ship_invoice" id="cus_ship" <?php echo $disable_ship; ?>>Ship</a> 
<!-- <a href="#" class="button edit-cancel" id="cus_cancel_order">Cancel Order</a> -->

<div class="hidden" id="invoice_overlay">
	<div id="inner">
		<div class="overlay-header">
			<span>X</span>
		</div>
		<div class="overlay-body">
			<input type="hidden" name="order_id" value="<?php echo $order_id; ?>">
			<table id="ord_inv" width="100%">
				<thead>
					<tr>
						<th><input type="checkbox" name="items-all" class="invoice_all_items invoice_status"></th>
						<th>Items Ordered</th>
						<th>Quantity Ordered</th>
						<th>Quantity to Invoice</th>
					</tr>
				</thead>
				<tbody>
					<!-- Content comes from ajax call -->
				</tbody>
			</table>
			<table id="inv_ship" width="100%">
				<thead>
					<tr>
						<th><input type="checkbox" name="items-all" class="ship_all_items ship_status"></th>
						<th>Items Invoiced</th>
						<th>Quantity Invoiced</th>
						<th>Quantity to Ship</th>
					</tr>
				</thead>
				<tbody>
					<!-- Content comes from ajax call -->
				</tbody>
			</table>
			<div class="carrier-tracking">
				<div class="carrier">
					<select name="select_carrier_invoice">
						<option value="">Select a carrier</option>
						<?php
						foreach ($carriers_array as $val) {
							echo "<option value='".$val."'>$val</option>";
						}
						?>
					</select>
				</div>
				<div class="tracking">
					<label>Enter Tracking Number:</label>
					<input type="text" name="tracking_number">
				</div>
			</div>
		</div>
		<div class="overlay-footer">
			<a href="#" class="button create_invoice only_invoice">Create Invoice</a>
			<a href="#" class="button create_invoice ship_as_well">Create Shipment</a>
		</div>

	</div>
</div>

<script type="text/javascript" src="<?php echo plugin_dir_url(__FILE__); ?>js/cancel_and_invoice.js"></script>
<script type="text/javascript" src="<?php echo plugin_dir_url(__FILE__); ?>js/ship_and_tracking.js"></script>
<script type="text/javascript">
	var cai = CancelAndInvoice().init();
</script>
<script type="text/javascript">
	var sat = ShipAndTracking().init();
</script>