<?php

if ( ! defined( 'ABSPATH' ) ) {
	echo "Silence is Golden.";
	die; // Exit if accessed directly
}

class Cancel_order {

	public $table_name = "woocommerce_order_invoice_details";
	public $carriers = array("DHL", "FedEx", "UPS", "USPS" , "USPS Priority Mail", "Purolator", "Other"
		);

	function __construct() {

		$this->activate_quivers_tables();
		add_action( 'add_meta_boxes', array($this,'mv_add_meta_boxes') );
		add_action( 'woocommerce_order_item_add_action_buttons', array($this,'add_cancel_button') );
		add_action( 'wp_ajax_woocommerce_cancel_order_manually', array($this, 'wp_ajax_cancel_order') );
		add_action( 'wp_ajax_woocommerce_generate_invoice', array($this, 'wp_ajax_get_order_details') );
		add_filter( 'woocommerce_admin_order_item_headers', array($this,'wc_new_order_column') );
		add_action('wp_ajax_woocommerce_add_entry_to_table', array($this, 'wp_ajax_create_invoice'));
		// add_action('wp_ajax_woocommerce_all_items_refunded', array($this, 'wp_ajax_status_refunded'));
		// add_action('wp_ajax_woocommerce_all_items_done', array($this, 'wp_ajax_status_completed'));
		add_action('wp_ajax_woocommerce_ship_invoice_overlay', array($this, 'wp_ajax_set_ship_overlay_data'));
		add_action( 'wp_ajax_woocommerce_ship_invoice', array($this, 'wp_ajax_ship_invoice') );
		add_action( 'woocommerce_admin_order_item_values', array($this, 'set_items_status'), 10, 3 );
	}

	function set_items_status($product, $item, $item_id){
		global $woocommerce;
		$order = new WC_Order($_GET['post']);
		$dispatched_qty = $this->calculate_dispatched_qty($order->get_id());
		$sum_array = $this->calculate_upper_limit_2($order->get_id());
		$items = $order->get_items();
		$ref_qty = $order->get_qty_refunded_for_item($item_id);
		?>
		<td class="item_status" item-id="<?php echo $item_id; ?>">
		<?php
			if( method_exists($item, "get_product_id") && method_exists($item, "get_variation_id")){
				$oq = $item->get_quantity();
				$iq = isset($sum_array[$item->get_name()][$item->get_product_id()][$item->get_variation_id()]) ? $sum_array[$item->get_name()][$item->get_product_id()][$item->get_variation_id()] : 0;
				$dq = isset($dispatched_qty[$item->get_name()][$item->get_product_id()][$item->get_variation_id()]) ? $dispatched_qty[$item->get_name()][$item->get_product_id()][$item->get_variation_id()] : 0;
				$str = "<div class='ord-ed'>Ordered <span class='o-qty'>". $oq ."</span></div>";
				$str .= $iq > 0 ? "<div class='inv-ed'>Invoiced <span class='i-qty'>". $iq ."</span></div>": "";
				$str .= $dq > 0 ? "<div class='dis-ed'>Dispatched <span class='d-qty'>". $dq ."</span></div>": "";
				// $str .= $ref_qty != 0 ? "<div class='ref-ed'>Refunded <span class='r-qty'>". abs($ref_qty) ."</span></div>": "";
				echo $str;

			}
		?>
		</td>
		<?php
	}

	function wc_new_order_column($order){
		?>
		<th class="item_status sortable" data-sort="float"><?php esc_html_e( "Item Status", "woocommerce" ); ?></th>
		<?php	
	}

	function mv_add_meta_boxes() {
		 add_meta_box( 'woocommerce-custom-invoice-data', __('Invoices & Shipments','woocommerce'), array($this, 'meta_box_content'), 'shop_order', 'normal', 'high' );
    
	}

	function wp_ajax_status_completed(){
		global $woocommerce;
		$order = new WC_Order($_POST['my_order_id']);
		$res = $order->update_status( 'wc-completed', 'All items either refunded or dispatched:' );
		$order->save();
		wp_send_json($res);
	}

	function wp_ajax_status_refunded(){
		global $woocommerce;
		$order = new WC_Order($_POST['my_order_id']);
		$res = $order->update_status( 'wc-refunded', 'All items refunded:' );
		$order->save();
		wp_send_json($res);
	}

	function wp_ajax_cancel_order(){
		global $woocommerce;
		$order = new WC_Order($_POST['my_order_id']);
		$res = $order->update_status( 'wc-cancelled', 'cs:' );
		$order->save();
		wp_send_json($res);
	}

	function wp_ajax_create_invoice(){
		$data = array(
			"order_id" 	=> $_POST['my_order_id'],
			"products" 	=> json_encode($_POST['item_details']),
			"carrier" 	=> $_POST['carrier'],
			"tracking_number" => $_POST['tracking'],
			"shipped"	=> $_POST['shipped'],
			"time" => current_time('mysql')
		);
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		// print_r($data); die;
		$res = $wpdb->insert($table_name, $data);
		// $res = $wpdb->get_results("select * from $table_name");
		// foreach ($res as $value) {
		// 	print_r(json_decode($value->products, true));
		// }
		wp_send_json($res);
	}

	function wp_ajax_get_order_details() {
		global $woocommerce;
		$order = new WC_Order($_POST['my_order_id']);
		$items = $order->get_items();
		$sum_array = $this->calculate_upper_limit_2($order->get_id());
		$sum_array_check = $this->calculate_upper_limit($order->get_id());
		$shipped = $this->calculate_dispatched_qty($order->get_id());
		$return_data = [];
		$rows = '';
		$rows2 = '';


		foreach ($items as $key => $item) {
			// print_r($item); die;
			$inv_ed = $sum_array[$item['name']][$item['product_id']][$item['variation_id']];
			$upperLimit = $item['quantity'] - @$inv_ed;
			$variation = $item['variation_id']? 'variation-id="'.$item['variation_id'].'"' : 'variation-id=0';
			// if($upperLimit > 0){
				$rows .= "<tr class='to_be_invoiced'><td class='item_status'><input type='checkbox' name='item_".$item["product_id"]."_".$item["variation_id"]."' class='invoice_item invoice_status' item-id=".$key."  product-id=".$item['product_id']." $variation></td>
							<td class='item_name'>". $item['name'] ."</td>
							<td class='item_qty'>". $item['quantity'] ."</td>
							<td class='invoice_qty'><input type='text' class='for_invoice' upperLimit=".$upperLimit." name='item1' value='". $upperLimit ."'><input type='hidden' name='item_total_".$item["product_id"]."_".$item["variation_id"]."' value=".$item->get_total()."></td></tr>";
			// }
			if(isset($inv_ed)){
				$ref_qty = absint($order->get_qty_refunded_for_item($key));
				$available_qty = $inv_ed - @$shipped[$item['name']][$item['product_id']][$item['variation_id']];
				$available_qty = $available_qty < 0 ? 0 : $available_qty;
				// if($available_qty > 0){
					$rows2 .= "<tr class='to_be_invoiced2'><td class='item_status2'><input type='checkbox' name='item_".$item["product_id"]."_".$item["variation_id"]."_2' class='invoice_item2 ship_status' item-id=".$key."  product-id=".$item['product_id']." $variation></td>
							<td class='item_name2'>". $item['name'] ."</td>
							<td class='item_qty2'>". $inv_ed ."</td>
							<td class='invoice_qty2'><input type='text' class='for_invoice2' upperLimit=".$available_qty." name='item2' value='". $available_qty ."'><input type='hidden' name='item_total_".$item["product_id"]."_".$item["variation_id"]."_2' value=".$item->get_total()."></td></tr>";
				// }
			}
		}

		$return_data['ordered_invoiced'] = $rows;
		$return_data['invoiced_shipped'] = $rows2;
		wp_send_json($return_data);
	}

	// function wp_ajax_get_order_details() {
	// 	global $woocommerce;
	// 	$order = new WC_Order($_POST['my_order_id']);
	// 	$items = $order->get_items();
	// 	$rows = '';
	// 	$sum_array = $this->calculate_upper_limit($order->get_id());

	// 	foreach ($items as $item) {
			
	// 	}

	// 	echo $rows;
	// }

	function wp_ajax_set_ship_overlay_data(){
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		$res = $wpdb->get_results("select carrier, tracking_number from $table_name where id=".$_POST['invoice_id'], ARRAY_A);
		wp_send_json($res);
	}

	function wp_ajax_ship_invoice(){
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		$res = $wpdb->update($table_name, array(
			'shipped'=>'true',
			'carrier' => $_POST['carrier'],
			'tracking_number' => $_POST['tracking_num']), array('id' =>$_POST['invoice_id'],
			'time' => current_time('mysql')
		));
		echo $res;
	}

	function meta_box_content(){
		$carriers_array = $this->carriers;
		include_once("html/shipment_overlay.php");
		global $wpdb, $woocommerce;
		$table_name = $wpdb->prefix . $this->table_name;
		$result = $wpdb->get_results("select * from $table_name where order_id=".$_GET['post'], ARRAY_A);
		$order = new WC_Order($_GET['post']);

		$shipping_cost = $order->get_total_shipping();
		$shipping_cost_string = "<td width='34%' style='text-align:right;'>Shipping Cost:</td><td width='20%' style='text-align:left;'><strong>$".number_format((float)$shipping_cost, 2, '.', '')."</strong></td>";
		// echo "<pre>"; print_r($result); die;
		if(sizeof($result) == 0){
			echo "<i>No invoice or shipment</i>";
		}
		foreach ($result as $value) {
			// print_r($value); 
			$value['products'] = json_decode($value['products'], true);
			if($value['shipped'] == '' || $value['shipped'] == 'false'){
				$value['payment_method'] = $order->get_payment_method() == 'cod'? 'Cash on delivery' : $order->get_payment_method() ;
				extract($value);
				include("html/meta_box_content_invoice.php");
			} else if($value['shipped'] == 'true'){
				extract($value);
				include("html/meta_box_content_shipment.php");
			}
			$shipping_cost_string = '<td></td><td></td>';
			$shipping_cost = 0;
		}
		// include_once("html/js/shipment_overlay_js.php");

		// 	include("html/meta_box_content_invoice.php");
	}

	function calculate_upper_limit($id){
		$sum_array = [];
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		$results = $wpdb->get_results("select products from $table_name where order_id='".$id."'");
		// print_r($results); die;
		foreach ($results as $value) {
			foreach(json_decode($value->products, true) as $item){
				$sum_array[$item['item_name']][$item['item_id']][$item['variation_id']] = @$sum_array[$item['item_name']][$item['item_id']][$item['variation_id']] + $item['invoiced_qty']; 
			}
		}
		// print_r($sum_array); die;
		return $sum_array;

	}

	function calculate_upper_limit_2($id){
		$sum_array = [];
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		$results = $wpdb->get_results("select products from $table_name where order_id='".$id."' and shipped='false'");
		// print_r($results); die;
		foreach ($results as $value) {
			foreach(json_decode($value->products, true) as $item){
				$sum_array[$item['item_name']][$item['item_id']][$item['variation_id']] = @$sum_array[$item['item_name']][$item['item_id']][$item['variation_id']] + $item['invoiced_qty']; 
			}
		}
		// print_r($sum_array); die;
		return $sum_array;

	}

	function calculate_dispatched_qty($order_id){
		$sum_array = [];
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		$results = $wpdb->get_results("select products from $table_name where order_id='".$order_id."' && shipped='true'");
		// print_r($results); die;
		foreach ($results as $value) {
			foreach(json_decode($value->products, true) as $item){
				$sum_array[$item['item_name']][$item['item_id']][$item['variation_id']] = @$sum_array[$item['item_name']][$item['item_id']][$item['variation_id']] + $item['invoiced_qty']; 
			}
		}
		// print_r($sum_array); die;
		return $sum_array;

	}

	function add_cancel_button($order) {
		$order_id = $order->get_id();
		
		global $wpdb;
		$table_name = $wpdb->prefix . $this->table_name;
		$results = $wpdb->get_results("select count(*) as invoices from $table_name where order_id=$order_id",ARRAY_A);
		$disable_ship = '';
		if(!$results[0]['invoices'] > 0){
			$disable_ship = 'disabled="disabled"';
		}

		$plugin_data = get_plugin_data( __FILE__ );
		$plugin_text_domain = $plugin_data['TextDomain'];
		$carriers_array = $this->carriers;
		include_once("html/custom_buttons.php");
		
		global $woocommerce;
		$order = new WC_Order($order_id);
		if($order->get_status() == "cancelled" || $order->get_status() == "completed" || $order->get_status() == "refunded")
		{
			include_once("html/js/custom_js.php");
		}
	}

	function activate_quivers_tables(){
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		$table_name = $wpdb->prefix . $this->table_name;
		$create = $wpdb->get_results("select * from ".$table_name);
		if(!sizeof(@$create)){
			$sql = "CREATE TABLE $table_name (
					id int NOT NULL AUTO_INCREMENT,
					order_id varchar(255),
					products longtext NOT NULL,
					carrier varchar(255),
					tracking_number varchar(255),
					shipped varchar(255),
					time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,			
					PRIMARY KEY (id)
				) $charset_collate;";

			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			dbDelta( $sql );
		}
	}

}
// finally instantiate our plugin class and add it to the set of globals
if( class_exists("Cancel_order") ) $GLOBALS['woo_cancel'] = new Cancel_order();

?>